/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.sphere;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.xmx.velthoric.builtin.sphere.SphereRigidBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SphereRenderer
extends VxRigidBodyRenderer<SphereRigidBody> {
    private static final int STACKS = 16;
    private static final int SECTORS = 32;

    @Override
    public void render(SphereRigidBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.pushPose();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.translate(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.mulPose(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        PoseStack.Pose lastPose = poseStack.last();
        Matrix4f poseMatrix = lastPose.pose();
        Matrix3f normalMatrix = lastPose.normal();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.solid());
        float radius = body.getSyncData(SphereRigidBody.DATA_RADIUS).floatValue();
        int r = 200;
        int g = 50;
        int b = 50;
        int a = 255;
        for (int i = 0; i < 16; ++i) {
            float phi1 = (float)((double)i * Math.PI / 16.0);
            float phi2 = (float)((double)(i + 1) * Math.PI / 16.0);
            for (int j = 0; j < 32; ++j) {
                float theta1 = (float)((double)(j * 2) * Math.PI / 32.0);
                float theta2 = (float)((double)((j + 1) * 2) * Math.PI / 32.0);
                Vector3f v1 = this.getSphereVertex(radius, phi1, theta1);
                Vector3f v2 = this.getSphereVertex(radius, phi1, theta2);
                Vector3f v3 = this.getSphereVertex(radius, phi2, theta2);
                Vector3f v4 = this.getSphereVertex(radius, phi2, theta1);
                this.addVertex(consumer, poseMatrix, normalMatrix, v1, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v2, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v4, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v2, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v3, r, g, b, a, packedLight);
                this.addVertex(consumer, poseMatrix, normalMatrix, v4, r, g, b, a, packedLight);
            }
        }
        poseStack.popPose();
    }

    private Vector3f getSphereVertex(float radius, float phi, float theta) {
        float x = (float)((double)radius * Math.sin(phi) * Math.cos(theta));
        float y = (float)((double)radius * Math.cos(phi));
        float z = (float)((double)radius * Math.sin(phi) * Math.sin(theta));
        return new Vector3f(x, y, z);
    }

    private void addVertex(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, Vector3f pos, int r, int g, int b, int a, int packedLight) {
        Vector3f normal = new Vector3f((Vector3fc)pos).normalize();
        normal.mul((Matrix3fc)normalMatrix);
        consumer.addVertex(poseMatrix, pos.x, pos.y, pos.z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
    }
}

