/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.sphere;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.SphereShapeSettings;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SphereRigidBody
extends VxRigidBody {
    public static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(SphereRigidBody.class, VxDataSerializers.FLOAT);

    public SphereRigidBody(VxBodyType<SphereRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SphereRigidBody(VxBodyType<SphereRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_RADIUS, Float.valueOf(0.5f));
    }

    public void setRadius(float radius) {
        this.setSyncData(DATA_RADIUS, Float.valueOf(radius > 0.0f ? radius : 0.5f));
    }

    public float getRadius() {
        return this.getSyncData(DATA_RADIUS).floatValue();
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        try (SphereShapeSettings shapeSettings = new SphereShapeSettings(this.getRadius());){
            int n;
            try (BodyCreationSettings bcs = new BodyCreationSettings();){
                bcs.setMotionType(EMotionType.Dynamic);
                bcs.setObjectLayer(1);
                n = factory.create(shapeSettings, bcs);
            }
            return n;
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.writeFloat(this.getRadius());
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        this.setRadius(buf.readFloat());
    }
}

