/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.registry.VxBodyRegistry;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxSummonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vxsummon").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            VxBodyRegistry registry = VxBodyRegistry.getInstance();
            return SharedSuggestionProvider.suggest(registry.getRegisteredTypes().values().stream().filter(VxBodyType::isSummonable).map(type -> type.getTypeId().toString()), (SuggestionsBuilder)builder);
        }).then(Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3((boolean)true)).executes(VxSummonCommand::execute))).executes(VxSummonCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) {
        Vec3 pos;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        try {
            pos = Vec3Argument.getVec3(context, (String)"position");
        }
        catch (IllegalArgumentException e) {
            pos = source.getPosition();
        }
        ResourceLocation typeId = ResourceLocationArgument.getId(context, (String)"type");
        try {
            VxBodyType<?> type = VxBodyRegistry.getInstance().getRegistrationData(typeId);
            if (type == null) {
                source.sendFailure((Component)Component.literal((String)("Physics body type not found: " + String.valueOf(typeId))));
                return 0;
            }
            if (!type.isSummonable()) {
                source.sendFailure((Component)Component.literal((String)("Physics body type '" + String.valueOf(typeId) + "' cannot be summoned.")));
                return 0;
            }
            VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)level.dimension());
            if (world == null) {
                source.sendFailure((Component)Component.literal((String)"Physics system for this dimension is not initialized."));
                return 0;
            }
            VxTransform transform = new VxTransform(new RVec3(pos.x, pos.y, pos.z), Quat.sIdentity());
            Object body = type.create(world, UUID.randomUUID());
            if (body == null) {
                source.sendFailure((Component)Component.literal((String)("Failed to create an instance of " + String.valueOf(typeId))));
                return 0;
            }
            world.getBodyManager().addConstructedBody((VxBody)body, EActivation.Activate, transform);
            source.sendSuccess(() -> Component.literal((String)String.format("Successfully summoned physics body '%s' with ID: %s", typeId, body.getPhysicsId())), true);
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)"An unexpected error occurred while executing the command."));
            e.printStackTrace();
            return 0;
        }
    }
}

