/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnBoxTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnBox";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3((boolean)true)).then(Commands.argument((String)"halfWidth", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).then(Commands.argument((String)"halfHeight", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).then(Commands.argument((String)"halfDepth", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(this::executeFull))))).then(Commands.argument((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(this::executeSized))).executes(this::executeDefault));
    }

    private int executeFull(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float halfWidth = FloatArgumentType.getFloat(context, (String)"halfWidth");
        float halfHeight = FloatArgumentType.getFloat(context, (String)"halfHeight");
        float halfDepth = FloatArgumentType.getFloat(context, (String)"halfDepth");
        Vec3 halfExtents = new Vec3(halfWidth, halfHeight, halfDepth);
        return this.spawn((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getVec3(context, (String)"position"), halfExtents);
    }

    private int executeSized(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float size = FloatArgumentType.getFloat(context, (String)"size");
        float halfExtent = size / 2.0f;
        Vec3 halfExtents = new Vec3(halfExtent, halfExtent, halfExtent);
        return this.spawn((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getVec3(context, (String)"position"), halfExtents);
    }

    private int executeDefault(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Vec3 halfExtents = new Vec3(0.5f, 0.5f, 0.5f);
        return this.spawn((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getLevel(), Vec3Argument.getVec3(context, (String)"position"), halfExtents);
    }

    private int spawn(CommandSourceStack source, ServerLevel serverLevel, net.minecraft.world.phys.Vec3 spawnPosMc, Vec3 halfExtents) {
        VxTransform transform;
        if (halfExtents.getX() <= 0.0f || halfExtents.getY() <= 0.0f || halfExtents.getZ() <= 0.0f) {
            source.sendFailure((Component)Component.literal((String)"Box dimensions (halfExtents) must be positive."));
            return 0;
        }
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)serverLevel.dimension());
        if (physicsWorld == null) {
            source.sendFailure((Component)Component.literal((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxBodyManager manager = physicsWorld.getBodyManager();
        BoxRigidBody spawnedBody = manager.createRigidBody(VxRegisteredBodies.BOX, transform = new VxTransform(new RVec3(spawnPosMc.x, spawnPosMc.y, spawnPosMc.z), Quat.sIdentity()), box -> box.setHalfExtents(halfExtents));
        if (spawnedBody != null) {
            source.sendSuccess(() -> Component.literal((String)String.format("Successfully spawned box (%.2f x %.2f x %.2f) with ID: %s", Float.valueOf(halfExtents.getX() * 2.0f), Float.valueOf(halfExtents.getY() * 2.0f), Float.valueOf(halfExtents.getZ() * 2.0f), spawnedBody.getPhysicsId())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Failed to register the box. Check logs for details."));
        return 0;
    }
}

