/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.cloth.ClothSoftBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SpawnClothTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnCloth";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3((boolean)true)).then(Commands.argument((String)"width", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.argument((String)"height", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.argument((String)"mass", (ArgumentType)FloatArgumentType.floatArg((float)0.1f)).then(Commands.argument((String)"segmentsWidth", (ArgumentType)IntegerArgumentType.integer((int)2, (int)50)).then(Commands.argument((String)"segmentsHeight", (ArgumentType)IntegerArgumentType.integer((int)2, (int)50)).executes(this::execute)))))));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        VxTransform transform;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        Vec3 pos = Vec3Argument.getVec3(context, (String)"pos");
        float width = FloatArgumentType.getFloat(context, (String)"width");
        float height = FloatArgumentType.getFloat(context, (String)"height");
        float mass = FloatArgumentType.getFloat(context, (String)"mass");
        int segmentsWidth = IntegerArgumentType.getInteger(context, (String)"segmentsWidth");
        int segmentsHeight = IntegerArgumentType.getInteger(context, (String)"segmentsHeight");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.dimension());
        if (physicsWorld == null) {
            source.sendFailure((Component)Component.literal((String)"Physics system for this dimension is not initialized."));
            return 0;
        }
        VxBodyManager manager = physicsWorld.getBodyManager();
        ClothSoftBody spawnedCloth = manager.createSoftBody(VxRegisteredBodies.CLOTH, transform = new VxTransform(new RVec3(pos.x(), pos.y(), pos.z()), Quat.sIdentity()), cloth -> cloth.setConfiguration(segmentsWidth, segmentsHeight, width, height, mass, 0.001f));
        if (spawnedCloth != null) {
            source.sendSuccess(() -> Component.literal((String)"Successfully spawned cloth."), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Failed to spawn the cloth. Check server logs."));
        return 0;
    }
}

