/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.marble.MarbleRigidBody;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class SpawnMarbleTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnMarble";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3((boolean)true)).executes(this::execute)).then(Commands.argument((String)"radius", (ArgumentType)FloatArgumentType.floatArg((float)0.05f)).executes(this::executeWithRadius)));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return this.spawnMarble(context, 0.15f);
    }

    private int executeWithRadius(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float radius = FloatArgumentType.getFloat(context, (String)"radius");
        return this.spawnMarble(context, radius);
    }

    private int spawnMarble(CommandContext<CommandSourceStack> context, float radius) throws CommandSyntaxException {
        VxTransform transform;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        Vec3 pos = Vec3Argument.getVec3(context, (String)"pos");
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.dimension());
        if (physicsWorld == null) {
            source.sendFailure((Component)Component.literal((String)"The physics system for this dimension is not initialized."));
            return 0;
        }
        VxBodyManager manager = physicsWorld.getBodyManager();
        MarbleRigidBody spawnedMarble = manager.createRigidBody(VxRegisteredBodies.MARBLE, transform = new VxTransform(new RVec3(pos.x(), pos.y(), pos.z()), Quat.sIdentity()), marble -> marble.setRadius(radius));
        if (spawnedMarble != null) {
            source.sendSuccess(() -> Component.literal((String)("Successfully spawned a marble with radius " + radius + ".")), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Failed to spawn the marble. Check the server logs."));
        return 0;
    }
}

