/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.command.test;

import com.github.stephengold.joltjni.RVec3;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.command.test.IVxTestCommand;
import net.xmx.velthoric.physics.ragdoll.VxRagdollManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class SpawnRagdollTest
implements IVxTestCommand {
    @Override
    public String getName() {
        return "spawnRagdoll";
    }

    @Override
    public void registerArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(this::execute)));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        Vec3 spawnPos = Vec3Argument.getVec3(context, (String)"position");
        if (!(entity instanceof LivingEntity)) {
            source.sendFailure((Component)Component.literal((String)"The target must be a living entity (e.g., a player, zombie, etc.)."));
            return 0;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)livingEntity.level().dimension());
        if (world == null) {
            source.sendFailure((Component)Component.literal((String)"The physics world is not running in this dimension."));
            return 0;
        }
        VxRagdollManager ragdollManager = world.getRagdollManager();
        if (ragdollManager != null) {
            RVec3 joltSpawnPos = new RVec3((float)spawnPos.x, (float)spawnPos.y, (float)spawnPos.z);
            ragdollManager.createHumanoidRagdoll(livingEntity, joltSpawnPos);
            source.sendSuccess(() -> Component.literal((String)("Spawning a ragdoll for " + livingEntity.getName().getString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Could not access the ragdoll manager."));
        return 0;
    }
}

