/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.debug;

import java.util.function.ToIntFunction;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.xmx.velthoric.physics.body.client.time.VxFrameTimer;

public class VxPhysicsDebugChart {
    public static void draw(GuiGraphics guiGraphics, Font font, VxFrameTimer frameTimer, int x, int width, int baseY, ToIntFunction<Integer> colorSampler) {
        int chartHeight = 60;
        guiGraphics.fill(RenderType.guiOverlay(), x, baseY - 60, x + width, baseY, -1873784752);
        int recordedFrames = frameTimer.getFrameCount();
        long totalTime = 0L;
        int minTime = Integer.MAX_VALUE;
        int maxTime = Integer.MIN_VALUE;
        int barsToDisplay = 0;
        if (recordedFrames > 0) {
            int i;
            long[] log = frameTimer.getLog();
            int logEnd = frameTimer.getLogEnd();
            int availableBarWidth = width - 2;
            barsToDisplay = Math.min(recordedFrames, availableBarWidth);
            for (i = 0; i < barsToDisplay; ++i) {
                int logIndex = frameTimer.wrapIndex(logEnd - 1 - i);
                int timeMs = (int)(log[logIndex] / 1000000L);
                minTime = Math.min(minTime, timeMs);
                maxTime = Math.max(maxTime, timeMs);
                totalTime += (long)timeMs;
            }
            for (i = 0; i < barsToDisplay; ++i) {
                int currentX = x + width - 2 - i;
                int logIndex = frameTimer.wrapIndex(logEnd - 1 - i);
                long durationNanos = log[logIndex];
                int scaledHeight = frameTimer.scaleSampleTo(durationNanos, 30, 60);
                int color = colorSampler.applyAsInt(Mth.clamp((int)scaledHeight, (int)0, (int)60));
                guiGraphics.fill(RenderType.guiOverlay(), currentX, baseY - scaledHeight, currentX + 1, baseY, color);
            }
        }
        guiGraphics.hLine(RenderType.guiOverlay(), x, x + width - 1, baseY - 60, -1);
        guiGraphics.hLine(RenderType.guiOverlay(), x, x + width - 1, baseY - 1, -1);
        guiGraphics.vLine(RenderType.guiOverlay(), x, baseY - 60, baseY, -1);
        guiGraphics.vLine(RenderType.guiOverlay(), x + width - 1, baseY - 60, baseY, -1);
        guiGraphics.drawString(font, "Physics", x + 2, baseY - 60 + 2, 0xE0E0E0, false);
        if (barsToDisplay > 0) {
            String minText = minTime + " ms min";
            String avgText = totalTime / (long)barsToDisplay + " ms avg";
            String maxText = maxTime + " ms max";
            guiGraphics.drawString(font, minText, x + 2, baseY - 60 - 9, 0xE0E0E0, false);
            guiGraphics.drawCenteredString(font, avgText, x + width / 2, baseY - 60 - 9, 0xE0E0E0);
            guiGraphics.drawString(font, maxText, x + width - font.width(maxText) - 2, baseY - 60 - 9, 0xE0E0E0);
        } else {
            guiGraphics.drawString(font, "0 ms min", x + 2, baseY - 60 - 9, 0xE0E0E0, false);
            guiGraphics.drawCenteredString(font, "0 ms avg", x + width / 2, baseY - 60 - 9, 0xE0E0E0);
            String maxText = "0 ms max";
            guiGraphics.drawString(font, maxText, x + width - font.width(maxText) - 2, baseY - 60 - 9, 0xE0E0E0);
        }
    }
}

