/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.boxthrower;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.builtin.box.BoxColor;
import net.xmx.velthoric.builtin.box.BoxRigidBody;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxBoxThrowerManager {
    private static final VxBoxThrowerManager INSTANCE = new VxBoxThrowerManager();
    private final Map<UUID, Boolean> shootingPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private static final int BOXES_PER_TICK = 5;
    private static final float SHOOT_SPEED = 40.0f;
    private static final float SPAWN_OFFSET = 1.5f;
    private static final float MIN_BOX_SIZE = 0.4f;
    private static final float MAX_BOX_SIZE = 1.2f;

    private VxBoxThrowerManager() {
    }

    public static VxBoxThrowerManager getInstance() {
        return INSTANCE;
    }

    public void startShooting(ServerPlayer player) {
        this.shootingPlayers.put(player.getUUID(), true);
    }

    public void stopShooting(ServerPlayer player) {
        this.shootingPlayers.remove(player.getUUID());
    }

    public boolean isShooting(ServerPlayer player) {
        return this.shootingPlayers.getOrDefault(player.getUUID(), false);
    }

    public void serverTick(ServerPlayer player) {
        VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.level().dimension());
        if (physicsWorld == null || !physicsWorld.isRunning()) {
            this.stopShooting(player);
            return;
        }
        physicsWorld.execute(() -> {
            for (int i = 0; i < 5; ++i) {
                this.spawnAndLaunchSingleBox(player, physicsWorld);
            }
        });
    }

    private void spawnAndLaunchSingleBox(ServerPlayer player, VxPhysicsWorld physicsWorld) {
        net.minecraft.world.phys.Vec3 eyePos = player.getEyePosition();
        net.minecraft.world.phys.Vec3 lookVec = player.getLookAngle();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        net.minecraft.world.phys.Vec3 spawnPosMc = eyePos.add(lookVec.scale(1.5));
        VxTransform transform = new VxTransform(new RVec3((float)spawnPosMc.x, (float)spawnPosMc.y, (float)spawnPosMc.z), Quat.sIdentity());
        float randomWidth = random.nextFloat(0.4f, 1.2f);
        float randomHeight = random.nextFloat(0.4f, 1.2f);
        float randomDepth = random.nextFloat(0.4f, 1.2f);
        Vec3 halfExtents = new Vec3(randomWidth / 2.0f, randomHeight / 2.0f, randomDepth / 2.0f);
        Vec3 launchVelocity = new Vec3((float)lookVec.x, (float)lookVec.y, (float)lookVec.z);
        launchVelocity.scaleInPlace(40.0f);
        VxBodyManager manager = physicsWorld.getBodyManager();
        BoxRigidBody spawnedBody = manager.createRigidBody(VxRegisteredBodies.BOX, transform, box -> {
            box.setHalfExtents(halfExtents);
            box.setColor(BoxColor.getRandom());
        });
        if (spawnedBody != null) {
            int bodyId = spawnedBody.getBodyId();
            BodyInterface bodyInterface = physicsWorld.getPhysicsSystem().getBodyInterface();
            bodyInterface.activateBody(bodyId);
            bodyInterface.setLinearVelocity(bodyId, launchVelocity);
        }
    }
}

