/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.boxthrower.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.xmx.velthoric.item.boxthrower.VxBoxThrowerManager;

public class VxBoxThrowerActionPacket {
    private final ActionType actionType;

    public VxBoxThrowerActionPacket(ActionType actionType) {
        this.actionType = actionType;
    }

    public static void encode(VxBoxThrowerActionPacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.actionType);
    }

    public static VxBoxThrowerActionPacket decode(FriendlyByteBuf buf) {
        return new VxBoxThrowerActionPacket((ActionType)buf.readEnum(ActionType.class));
    }

    public static void handle(VxBoxThrowerActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxBoxThrowerManager manager = VxBoxThrowerManager.getInstance();
            switch (msg.actionType.ordinal()) {
                case 0: {
                    manager.startShooting(player);
                    break;
                }
                case 1: {
                    manager.stopShooting(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_SHOOTING,
        STOP_SHOOTING;

    }
}

