/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.chaincreator;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.builtin.VxRegisteredBodies;
import net.xmx.velthoric.item.chaincreator.body.VxChainPartRigidBody;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxRaycaster;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public enum VxChainCreatorManager {
    INSTANCE;

    private final Map<UUID, VxHitResult> chainCreators = new ConcurrentHashMap<UUID, VxHitResult>();
    private VxPhysicsWorld world;

    public void startChainCreation(ServerPlayer player) {
        this.performRaycast(player).ifPresent(hitResult -> {
            this.chainCreators.put(player.getUUID(), (VxHitResult)((Object)hitResult));
            player.level().playSound(null, new BlockPos((int)hitResult.getLocation().x, (int)hitResult.getLocation().y, (int)hitResult.getLocation().z), SoundEvents.CHAIN_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    public void finishChainCreation(ServerPlayer player) {
        VxHitResult startHit = this.chainCreators.remove(player.getUUID());
        if (startHit == null) {
            return;
        }
        this.performRaycast(player).ifPresent(endHit -> {
            player.level().playSound(null, new BlockPos((int)endHit.getLocation().x, (int)endHit.getLocation().y, (int)endHit.getLocation().z), SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.world.execute(() -> this.createChain(startHit, (VxHitResult)((Object)endHit)));
        });
    }

    private void createChain(VxHitResult startHit, VxHitResult endHit) {
        VxBody endBody;
        VxPhysicsWorld world = this.world;
        if (world == null) {
            return;
        }
        VxBodyManager bodyManager = world.getBodyManager();
        VxConstraintManager constraintManager = world.getConstraintManager();
        BodyInterface bodyInterface = world.getPhysicsSystem().getBodyInterface();
        AttachmentInfo startInfo = this.getAttachmentInfo(bodyManager, startHit);
        AttachmentInfo endInfo = this.getAttachmentInfo(bodyManager, endHit);
        if (startInfo.bodyUUID.equals(endInfo.bodyUUID) && !startInfo.bodyUUID.equals(VxConstraintManager.WORLD_BODY_ID)) {
            return;
        }
        VxBody startBody = bodyManager.getVxBody(startInfo.bodyUUID);
        if (startBody != null) {
            bodyInterface.activateBody(startBody.getBodyId());
        }
        if ((endBody = bodyManager.getVxBody(endInfo.bodyUUID)) != null) {
            bodyInterface.activateBody(endBody.getBodyId());
        }
        RVec3 startPos = startInfo.worldPosition;
        RVec3 endPos = endInfo.worldPosition;
        double chainPartRadius = 0.2;
        double desiredSegmentLength = 0.25;
        RVec3 vector = Op.minus((RVec3Arg)endPos, startPos);
        double distance = vector.length();
        if (distance < 0.25) {
            return;
        }
        int numSegments = Math.max(1, (int)Math.ceil(distance / 0.25));
        double actualSegmentLength = distance / (double)numSegments;
        RVec3 direction = vector.normalized();
        Quat orientation = Quat.sFromTo(new Vec3(0.0f, 1.0f, 0.0f), direction.toVec3());
        RVec3 segmentVector = Op.star(actualSegmentLength, (RVec3Arg)direction);
        UUID previousBodyUuid = startInfo.bodyUUID;
        RVec3 pivotOnPreviousBody = startInfo.localPivot;
        for (int i = 0; i < numSegments; ++i) {
            RVec3 segmentStartPos = Op.plus((RVec3Arg)startPos, (RVec3Arg)Op.star((double)i, (RVec3Arg)segmentVector));
            RVec3 segmentCenterPos = Op.plus((RVec3Arg)segmentStartPos, (RVec3Arg)Op.star(0.5, (RVec3Arg)segmentVector));
            VxChainPartRigidBody currentBody = bodyManager.createRigidBody(VxRegisteredBodies.CHAIN_PART, new VxTransform(segmentCenterPos, orientation), body -> {
                body.setSyncData(VxChainPartRigidBody.getLengthAccessor(), Float.valueOf((float)actualSegmentLength));
                body.setSyncData(VxChainPartRigidBody.getRadiusAccessor(), Float.valueOf(0.2f));
            });
            if (currentBody == null) continue;
            bodyInterface.activateBody(currentBody.getBodyId());
            RVec3 pivotOnCurrentBodyLocal = new RVec3(0.0, -actualSegmentLength / 2.0, 0.0);
            try (PointConstraintSettings settings = new PointConstraintSettings();){
                if (previousBodyUuid.equals(VxConstraintManager.WORLD_BODY_ID)) {
                    settings.setSpace(EConstraintSpace.WorldSpace);
                    settings.setPoint1(pivotOnPreviousBody);
                    RMat44 segmentRotation = new RMat44();
                    RMat44.sRotation(orientation);
                    Vec3 rotatedPivot = segmentRotation.multiply3x3(pivotOnCurrentBodyLocal.toVec3());
                    RVec3 pivotOnCurrentBodyWorld = Op.plus((RVec3Arg)segmentCenterPos, (Vec3Arg)rotatedPivot);
                    settings.setPoint2(pivotOnCurrentBodyWorld);
                } else {
                    settings.setSpace(EConstraintSpace.LocalToBodyCom);
                    settings.setPoint1(pivotOnPreviousBody);
                    settings.setPoint2(pivotOnCurrentBodyLocal);
                }
                constraintManager.createConstraint(settings, previousBodyUuid, currentBody.getPhysicsId());
            }
            previousBodyUuid = currentBody.getPhysicsId();
            pivotOnPreviousBody = new RVec3(0.0, actualSegmentLength / 2.0, 0.0);
        }
        try (PointConstraintSettings settings = new PointConstraintSettings();){
            VxBody lastLinkBody = bodyManager.getVxBody(previousBodyUuid);
            if (lastLinkBody == null) {
                return;
            }
            if (endInfo.bodyUUID.equals(VxConstraintManager.WORLD_BODY_ID)) {
                settings.setSpace(EConstraintSpace.WorldSpace);
                RMat44 lastLinkTransform = world.getPhysicsSystem().getBodyInterface().getCenterOfMassTransform(lastLinkBody.getBodyId());
                RVec3 pivotOnLastLinkWorld = lastLinkTransform.multiply3x4(pivotOnPreviousBody);
                settings.setPoint1(pivotOnLastLinkWorld);
                settings.setPoint2(endInfo.localPivot);
            } else {
                settings.setSpace(EConstraintSpace.LocalToBodyCom);
                settings.setPoint1(pivotOnPreviousBody);
                settings.setPoint2(endInfo.localPivot);
            }
            constraintManager.createConstraint(settings, previousBodyUuid, endInfo.bodyUUID);
        }
    }

    private AttachmentInfo getAttachmentInfo(VxBodyManager bodyManager, VxHitResult hit) {
        VxHitResult.PhysicsHit physicsHit;
        VxBody hitBody;
        RVec3 worldPosition = new RVec3(hit.getLocation().x, hit.getLocation().y, hit.getLocation().z);
        if (hit.isPhysicsHit() && (hitBody = bodyManager.getByJoltBodyId((physicsHit = hit.getPhysicsHit().get()).bodyId())) != null && hitBody.getBodyId() != 0) {
            BodyInterface bodyInterface = bodyManager.getPhysicsWorld().getPhysicsSystem().getBodyInterface();
            RMat44 inverseTransform = bodyInterface.getCenterOfMassTransform(hitBody.getBodyId()).inversed();
            RVec3 localPivot = inverseTransform.multiply3x4(worldPosition);
            return new AttachmentInfo(hitBody.getPhysicsId(), worldPosition, localPivot);
        }
        return new AttachmentInfo(VxConstraintManager.WORLD_BODY_ID, worldPosition, worldPosition);
    }

    private Optional<VxHitResult> performRaycast(ServerPlayer player) {
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)player.level().dimension());
        if (world == null) {
            return Optional.empty();
        }
        this.world = world;
        double reachDistance = player.isCreative() ? 5.0 : 4.5;
        net.minecraft.world.phys.Vec3 from = player.getEyePosition();
        net.minecraft.world.phys.Vec3 look = player.getLookAngle();
        net.minecraft.world.phys.Vec3 to = from.add(look.scale(reachDistance));
        VxClipContext context = new VxClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player, true);
        return VxRaycaster.raycast(player.level(), context);
    }

    public void onPlayerQuit(ServerPlayer player) {
        this.chainCreators.remove(player.getUUID());
    }

    private record AttachmentInfo(UUID bodyUUID, RVec3 worldPosition, RVec3 localPivot) {
    }
}

