/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.beam;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.xmx.velthoric.event.api.VxRenderEvent;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunClientManager;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyInterpolator;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class VxPhysicsGunBeamRenderer {
    private static final int BEAM_SEGMENTS = 20;
    private static final float BEAM_WIDTH = 0.15f;
    private static final float BEAM_CURVE_STRENGTH = 0.3f;
    private static final float BEAM_MAX_LENGTH = 100.0f;
    private static final RVec3 INTERPOLATED_POSITION = new RVec3();
    private static final Quat INTERPOLATED_ROTATION = new Quat();

    public static void registerEvents() {
        VxRenderEvent.ClientRenderLevelStageEvent.EVENT.register(VxPhysicsGunBeamRenderer::onRenderLevelStage);
    }

    public static void onRenderLevelStage(VxRenderEvent.ClientRenderLevelStageEvent event) {
        if (event.getStage() != VxRenderEvent.ClientRenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null || mc.level == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        VxPhysicsGunClientManager clientManager = VxPhysicsGunClientManager.getInstance();
        VxClientBodyManager bodyManager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = bodyManager.getStore();
        VxClientBodyInterpolator interpolator = bodyManager.getInterpolator();
        Camera camera = mc.gameRenderer.getMainCamera();
        net.minecraft.world.phys.Vec3 camPos = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        Map<UUID, VxPhysicsGunClientManager.ClientGrabData> activeGrabs = clientManager.getActiveGrabs();
        for (Map.Entry<UUID, VxPhysicsGunClientManager.ClientGrabData> entry : activeGrabs.entrySet()) {
            UUID playerUuid = entry.getKey();
            VxPhysicsGunClientManager.ClientGrabData grabData = entry.getValue();
            UUID objectUuid = grabData.objectUuid();
            Player player = mc.level.getPlayerByUUID(playerUuid);
            if (player == null) continue;
            Integer index = store.getIndexForId(objectUuid);
            VxBody body = bodyManager.getBody(objectUuid);
            if (index == null || !store.render_isInitialized[index] || !(body instanceof VxRigidBody)) continue;
            interpolator.interpolateFrame(store, index, partialTicks, INTERPOLATED_POSITION, INTERPOLATED_ROTATION);
            net.minecraft.world.phys.Vec3 startPoint = VxPhysicsGunBeamRenderer.getGunTipPosition(player, partialTicks);
            RVec3 centerPos = INTERPOLATED_POSITION;
            Quat rotation = INTERPOLATED_ROTATION;
            net.minecraft.world.phys.Vec3 localHitPoint = grabData.localHitPoint();
            Vec3 localHitJolt = new Vec3((float)localHitPoint.x(), (float)localHitPoint.y(), (float)localHitPoint.z());
            Vec3 rotatedOffset = Op.star((QuatArg)rotation, (Vec3Arg)localHitJolt);
            RVec3 endPointJolt = Op.plus((RVec3Arg)centerPos, (Vec3Arg)rotatedOffset);
            net.minecraft.world.phys.Vec3 endPoint = new net.minecraft.world.phys.Vec3(endPointJolt.xx(), endPointJolt.yy(), endPointJolt.zz());
            net.minecraft.world.phys.Vec3 playerLookVec = VxPhysicsGunBeamRenderer.getPlayerLookVector(player, partialTicks);
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            VxPhysicsGunBeamRenderer.drawThickCurvedBeam((VertexConsumer)bufferBuilder, matrix, camPos, startPoint, endPoint, playerLookVec);
            MeshData meshData = bufferBuilder.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        Set<UUID> playersTryingToGrab = clientManager.getPlayersTryingToGrab();
        for (UUID playerUuid : playersTryingToGrab) {
            net.minecraft.world.phys.Vec3 traceEnd;
            ClipContext clipContext;
            BlockHitResult blockHitResult;
            Player player;
            if (activeGrabs.containsKey(playerUuid) || (player = mc.level.getPlayerByUUID(playerUuid)) == null) continue;
            net.minecraft.world.phys.Vec3 startPoint = VxPhysicsGunBeamRenderer.getGunTipPosition(player, partialTicks);
            net.minecraft.world.phys.Vec3 playerLookVec = VxPhysicsGunBeamRenderer.getPlayerLookVector(player, partialTicks);
            net.minecraft.world.phys.Vec3 traceStart = player.getEyePosition(partialTicks);
            Optional<net.minecraft.world.phys.Vec3> physicsHitPoint = VxPhysicsGunBeamRenderer.raycastClientPhysicsBodies(traceStart, playerLookVec, 100.0f, store, interpolator, partialTicks);
            net.minecraft.world.phys.Vec3 endPoint = physicsHitPoint.isPresent() ? physicsHitPoint.get() : ((blockHitResult = mc.level.clip(clipContext = new ClipContext(traceStart, traceEnd = traceStart.add(playerLookVec.scale(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))).getType() == HitResult.Type.MISS ? traceEnd : blockHitResult.getLocation());
            BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            VxPhysicsGunBeamRenderer.drawThickCurvedBeam((VertexConsumer)bufferBuilder, matrix, camPos, startPoint, endPoint, playerLookVec);
            MeshData meshData = bufferBuilder.buildOrThrow();
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static Optional<net.minecraft.world.phys.Vec3> raycastClientPhysicsBodies(net.minecraft.world.phys.Vec3 rayOrigin, net.minecraft.world.phys.Vec3 rayDirection, float maxDistance, VxClientBodyDataStore store, VxClientBodyInterpolator interpolator, float partialTicks) {
        double closestHitDist = maxDistance;
        net.minecraft.world.phys.Vec3 hitPoint = null;
        double OBJECT_RADIUS = 1.5;
        double OBJECT_RADIUS_SQR = 2.25;
        RVec3 tempPos = new RVec3();
        Quat tempRot = new Quat();
        for (UUID id : store.getAllPhysicsIds()) {
            double t_hit;
            double d2;
            Integer i = store.getIndexForId(id);
            if (i == null || !store.render_isInitialized[i]) continue;
            interpolator.interpolateFrame(store, i, partialTicks, tempPos, tempRot);
            net.minecraft.world.phys.Vec3 objectCenter = new net.minecraft.world.phys.Vec3(tempPos.xx(), tempPos.yy(), tempPos.zz());
            net.minecraft.world.phys.Vec3 originToCenter = objectCenter.subtract(rayOrigin);
            double t = originToCenter.dot(rayDirection);
            if (t < 0.0 || t > closestHitDist || !((d2 = originToCenter.lengthSqr() - t * t) < 2.25) || !((t_hit = t - Math.sqrt(2.25 - d2)) < closestHitDist) || !(t_hit >= 0.0)) continue;
            closestHitDist = t_hit;
            hitPoint = rayOrigin.add(rayDirection.scale(closestHitDist));
        }
        return Optional.ofNullable(hitPoint);
    }

    private static void drawThickCurvedBeam(VertexConsumer bufferBuilder, Matrix4f matrix, net.minecraft.world.phys.Vec3 camPos, net.minecraft.world.phys.Vec3 start, net.minecraft.world.phys.Vec3 end, net.minecraft.world.phys.Vec3 playerLookVec) {
        float r = 0.9725f;
        float g = 0.2863f;
        float b = 0.0117f;
        float baseAlpha = 0.83f;
        double distance = start.distanceTo(end);
        net.minecraft.world.phys.Vec3 p0 = start;
        net.minecraft.world.phys.Vec3 p3 = end;
        net.minecraft.world.phys.Vec3 p1 = p0.add(playerLookVec.scale(distance * (double)0.3f));
        net.minecraft.world.phys.Vec3 tangentAtEnd = p0.subtract(p3).normalize();
        net.minecraft.world.phys.Vec3 p2 = p3.add(tangentAtEnd.scale(distance * (double)0.3f));
        net.minecraft.world.phys.Vec3 lastPos = p0;
        for (int i = 0; i <= 20; ++i) {
            net.minecraft.world.phys.Vec3 segmentDir;
            float t = (float)i / 20.0f;
            net.minecraft.world.phys.Vec3 currentPos = VxPhysicsGunBeamRenderer.getCubicBezierPoint(t, p0, p1, p2, p3);
            net.minecraft.world.phys.Vec3 viewDir = currentPos.subtract(camPos).normalize();
            net.minecraft.world.phys.Vec3 vec3 = segmentDir = i == 0 ? p1.subtract(p0).normalize() : currentPos.subtract(lastPos).normalize();
            if (segmentDir.lengthSqr() < 1.0E-6) {
                segmentDir = playerLookVec;
            }
            net.minecraft.world.phys.Vec3 side = segmentDir.cross(viewDir).normalize().scale((double)0.075f);
            bufferBuilder.addVertex(matrix, (float)(currentPos.x + side.x), (float)(currentPos.y + side.y), (float)(currentPos.z + side.z)).setColor(r, g, b, baseAlpha);
            bufferBuilder.addVertex(matrix, (float)(currentPos.x - side.x), (float)(currentPos.y - side.y), (float)(currentPos.z - side.z)).setColor(r, g, b, baseAlpha);
            lastPos = currentPos;
        }
    }

    private static net.minecraft.world.phys.Vec3 getCubicBezierPoint(float t, net.minecraft.world.phys.Vec3 p0, net.minecraft.world.phys.Vec3 p1, net.minecraft.world.phys.Vec3 p2, net.minecraft.world.phys.Vec3 p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        float uuu = uu * u;
        float ttt = tt * t;
        net.minecraft.world.phys.Vec3 p = p0.scale((double)uuu);
        p = p.add(p1.scale((double)(3.0f * uu * t)));
        p = p.add(p2.scale((double)(3.0f * u * tt)));
        p = p.add(p3.scale((double)ttt));
        return p;
    }

    private static net.minecraft.world.phys.Vec3 getPlayerLookVector(Player player, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (player.is((Entity)mc.player) && mc.options.getCameraType().isFirstPerson()) {
            Camera camera = mc.gameRenderer.getMainCamera();
            Vector3f lookVector = camera.getLookVector();
            return new net.minecraft.world.phys.Vec3((double)lookVector.x(), (double)lookVector.y(), (double)lookVector.z());
        }
        return player.getViewVector(partialTicks);
    }

    private static net.minecraft.world.phys.Vec3 getGunTipPosition(Player player, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        if (player.is((Entity)mc.player) && mc.options.getCameraType().isFirstPerson()) {
            Camera camera = mc.gameRenderer.getMainCamera();
            Vector3f lookVector = camera.getLookVector();
            net.minecraft.world.phys.Vec3 camForward = new net.minecraft.world.phys.Vec3((double)lookVector.x(), (double)lookVector.y(), (double)lookVector.z());
            Vector3f upVector = camera.getUpVector();
            net.minecraft.world.phys.Vec3 camUp = new net.minecraft.world.phys.Vec3((double)upVector.x(), (double)upVector.y(), (double)upVector.z());
            net.minecraft.world.phys.Vec3 camRight = camForward.cross(camUp).normalize();
            return camera.getPosition().add(camForward.scale(0.5)).add(camRight.scale(0.3)).add(camUp.scale(-0.15));
        }
        net.minecraft.world.phys.Vec3 eyePos = player.getEyePosition(partialTicks);
        net.minecraft.world.phys.Vec3 lookVec = player.getViewVector(partialTicks);
        net.minecraft.world.phys.Vec3 upVec = player.getUpVector(partialTicks);
        net.minecraft.world.phys.Vec3 rightVec = lookVec.cross(upVec).normalize();
        return eyePos.add(lookVec.scale(0.3)).add(rightVec.scale(-0.35)).add(upVec.scale(-0.3));
    }
}

