/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.physicsgun.packet;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunServerManager;

public class VxPhysicsGunActionPacket {
    private final ActionType actionType;
    private final float value1;
    private final float value2;

    public VxPhysicsGunActionPacket(ActionType actionType) {
        this(actionType, 0.0f, 0.0f);
    }

    public VxPhysicsGunActionPacket(float scrollDelta) {
        this(ActionType.UPDATE_SCROLL, scrollDelta, 0.0f);
    }

    public VxPhysicsGunActionPacket(float deltaX, float deltaY) {
        this(ActionType.UPDATE_ROTATION, deltaX, deltaY);
    }

    private VxPhysicsGunActionPacket(ActionType actionType, float value1, float value2) {
        this.actionType = actionType;
        this.value1 = value1;
        this.value2 = value2;
    }

    public static void encode(VxPhysicsGunActionPacket msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.actionType);
        if (msg.actionType == ActionType.UPDATE_SCROLL) {
            buf.writeFloat(msg.value1);
        } else if (msg.actionType == ActionType.UPDATE_ROTATION) {
            buf.writeFloat(msg.value1);
            buf.writeFloat(msg.value2);
        }
    }

    public static VxPhysicsGunActionPacket decode(FriendlyByteBuf buf) {
        ActionType actionType = (ActionType)buf.readEnum(ActionType.class);
        float value1 = 0.0f;
        float value2 = 0.0f;
        if (actionType == ActionType.UPDATE_SCROLL) {
            value1 = buf.readFloat();
        } else if (actionType == ActionType.UPDATE_ROTATION) {
            value1 = buf.readFloat();
            value2 = buf.readFloat();
        }
        return new VxPhysicsGunActionPacket(actionType, value1, value2);
    }

    public static void handle(VxPhysicsGunActionPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxPhysicsGunServerManager manager = VxPhysicsGunServerManager.getInstance();
            switch (msg.actionType.ordinal()) {
                case 0: {
                    manager.startGrabAttempt(player);
                    break;
                }
                case 1: {
                    manager.stopGrabAttempt(player);
                    break;
                }
                case 2: {
                    manager.updateScroll(player, msg.value1);
                    break;
                }
                case 3: {
                    manager.updateRotation(player, msg.value1, msg.value2);
                    break;
                }
                case 4: {
                    manager.freezeBody(player);
                    break;
                }
                case 5: {
                    manager.startRotationMode(player);
                    break;
                }
                case 6: {
                    manager.stopRotationMode(player);
                }
            }
        });
    }

    public static enum ActionType {
        START_GRAB_ATTEMPT,
        STOP_GRAB_ATTEMPT,
        UPDATE_SCROLL,
        UPDATE_ROTATION,
        FREEZE_OBJECT,
        START_ROTATION_MODE,
        STOP_ROTATION_MODE;

    }
}

