/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.math;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import java.util.Optional;
import net.minecraft.world.phys.AABB;
import net.xmx.velthoric.math.VxTransform;

public class VxOBB {
    private static final double EPSILON = 1.0E-7;
    public final VxTransform transform;
    public final AABB localAABB;

    public VxOBB(VxTransform transform, AABB localAABB) {
        this.transform = transform.copy();
        this.localAABB = localAABB;
    }

    public VxOBB(VxTransform transform, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.transform = transform.copy();
        this.localAABB = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static VxOBB ofSize(VxTransform transform, net.minecraft.world.phys.Vec3 center, double xSize, double ySize, double zSize) {
        AABB local = new AABB(-xSize / 2.0, -ySize / 2.0, -zSize / 2.0, xSize / 2.0, ySize / 2.0, zSize / 2.0);
        VxTransform newTransform = transform.copy();
        newTransform.getTranslation().set(center.x, center.y, center.z);
        return new VxOBB(newTransform, local);
    }

    public net.minecraft.world.phys.Vec3 getCenter() {
        RVec3 center = this.transform.getTranslation();
        return new net.minecraft.world.phys.Vec3(center.xx(), center.yy(), center.zz());
    }

    public net.minecraft.world.phys.Vec3 getExtents() {
        return new net.minecraft.world.phys.Vec3(this.localAABB.getXsize() / 2.0, this.localAABB.getYsize() / 2.0, this.localAABB.getZsize() / 2.0);
    }

    public VxOBB move(double x, double y, double z) {
        VxTransform newTransform = this.transform.copy();
        RVec3 translation = newTransform.getTranslation();
        translation.set(translation.xx() + x, translation.yy() + y, translation.zz() + z);
        return new VxOBB(newTransform, this.localAABB);
    }

    public VxOBB move(net.minecraft.world.phys.Vec3 vec) {
        return this.move(vec.x, vec.y, vec.z);
    }

    public VxOBB rotate(Quat rotation) {
        VxTransform newTransform = this.transform.copy();
        Quat resultRotation = Op.star((QuatArg)newTransform.getRotation(), (QuatArg)rotation);
        newTransform.getRotation().set(resultRotation);
        return new VxOBB(newTransform, this.localAABB);
    }

    public VxOBB inflate(double value) {
        return new VxOBB(this.transform, this.localAABB.inflate(value));
    }

    public VxOBB inflate(double x, double y, double z) {
        return new VxOBB(this.transform, this.localAABB.inflate(x, y, z));
    }

    public VxOBB deflate(double value) {
        return new VxOBB(this.transform, this.localAABB.deflate(value));
    }

    public boolean contains(net.minecraft.world.phys.Vec3 point) {
        net.minecraft.world.phys.Vec3 localPoint = this.transformToLocal(point);
        return this.localAABB.contains(localPoint);
    }

    public boolean intersects(VxOBB other) {
        double rb;
        int i;
        net.minecraft.world.phys.Vec3 extentsA = this.getExtents();
        Quat rotA = this.transform.getRotation();
        net.minecraft.world.phys.Vec3[] axesA = new net.minecraft.world.phys.Vec3[]{VxOBB.toMcVec3(rotA.rotateAxisX()), VxOBB.toMcVec3(rotA.rotateAxisY()), VxOBB.toMcVec3(rotA.rotateAxisZ())};
        net.minecraft.world.phys.Vec3 extentsB = other.getExtents();
        Quat rotB = other.transform.getRotation();
        net.minecraft.world.phys.Vec3[] axesB = new net.minecraft.world.phys.Vec3[]{VxOBB.toMcVec3(rotB.rotateAxisX()), VxOBB.toMcVec3(rotB.rotateAxisY()), VxOBB.toMcVec3(rotB.rotateAxisZ())};
        net.minecraft.world.phys.Vec3 t = other.getCenter().subtract(this.getCenter());
        double[][] R = new double[3][3];
        double[][] absR = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = axesA[i].dot(axesB[j]);
                absR[i][j] = Math.abs(R[i][j]) + 1.0E-7;
            }
        }
        for (i = 0; i < 3; ++i) {
            double ra = VxOBB.getComponent(extentsA, i);
            rb = VxOBB.getComponent(extentsB, 0) * absR[i][0] + VxOBB.getComponent(extentsB, 1) * absR[i][1] + VxOBB.getComponent(extentsB, 2) * absR[i][2];
            if (!(Math.abs(axesA[i].dot(t)) > ra + rb)) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            double ra = VxOBB.getComponent(extentsA, 0) * absR[0][i] + VxOBB.getComponent(extentsA, 1) * absR[1][i] + VxOBB.getComponent(extentsA, 2) * absR[2][i];
            rb = VxOBB.getComponent(extentsB, i);
            double projection = axesB[i].dot(t);
            if (!(Math.abs(projection) > ra + rb)) continue;
            return false;
        }
        double ra = extentsA.y * absR[2][0] + extentsA.z * absR[1][0];
        double rb2 = extentsB.y * absR[0][2] + extentsB.z * absR[0][1];
        if (Math.abs(t.z * R[1][0] - t.y * R[2][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.y * absR[2][1] + extentsA.z * absR[1][1];
        rb2 = extentsB.x * absR[0][2] + extentsB.z * absR[0][0];
        if (Math.abs(t.z * R[1][1] - t.y * R[2][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.y * absR[2][2] + extentsA.z * absR[1][2];
        rb2 = extentsB.x * absR[0][1] + extentsB.y * absR[0][0];
        if (Math.abs(t.z * R[1][2] - t.y * R[2][2]) > ra + rb2) {
            return false;
        }
        ra = extentsA.x * absR[2][0] + extentsA.z * absR[0][0];
        rb2 = extentsB.y * absR[1][2] + extentsB.z * absR[1][1];
        if (Math.abs(t.x * R[2][0] - t.z * R[0][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.x * absR[2][1] + extentsA.z * absR[0][1];
        rb2 = extentsB.x * absR[1][2] + extentsB.z * absR[1][0];
        if (Math.abs(t.x * R[2][1] - t.z * R[0][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.x * absR[2][2] + extentsA.z * absR[0][2];
        rb2 = extentsB.x * absR[1][1] + extentsB.y * absR[1][0];
        if (Math.abs(t.x * R[2][2] - t.z * R[0][2]) > ra + rb2) {
            return false;
        }
        ra = extentsA.x * absR[1][0] + extentsA.y * absR[0][0];
        rb2 = extentsB.y * absR[2][2] + extentsB.z * absR[2][1];
        if (Math.abs(t.y * R[0][0] - t.x * R[1][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.x * absR[1][1] + extentsA.y * absR[0][1];
        rb2 = extentsB.x * absR[2][2] + extentsB.z * absR[2][0];
        if (Math.abs(t.y * R[0][1] - t.x * R[1][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.x * absR[1][2] + extentsA.y * absR[0][2];
        rb2 = extentsB.x * absR[2][1] + extentsB.y * absR[2][0];
        return !(Math.abs(t.y * R[0][2] - t.x * R[1][2]) > ra + rb2);
    }

    public boolean intersectsWith(AABB aabb) {
        net.minecraft.world.phys.Vec3 center = aabb.getCenter();
        double hx = aabb.getXsize() / 2.0;
        double hy = aabb.getYsize() / 2.0;
        double hz = aabb.getZsize() / 2.0;
        VxTransform aabbTransform = new VxTransform(new RVec3(center.x, center.y, center.z), new Quat());
        AABB localAABB = new AABB(-hx, -hy, -hz, hx, hy, hz);
        VxOBB other = new VxOBB(aabbTransform, localAABB);
        return this.intersects(other);
    }

    public Optional<net.minecraft.world.phys.Vec3> clip(net.minecraft.world.phys.Vec3 from, net.minecraft.world.phys.Vec3 to) {
        net.minecraft.world.phys.Vec3 localFrom = this.transformToLocal(from);
        net.minecraft.world.phys.Vec3 localTo = this.transformToLocal(to);
        Optional localHit = this.localAABB.clip(localFrom, localTo);
        return localHit.map(this::transformToWorld);
    }

    public AABB getBounds() {
        net.minecraft.world.phys.Vec3[] corners = this.getCorners();
        net.minecraft.world.phys.Vec3 min = corners[0];
        net.minecraft.world.phys.Vec3 max = corners[0];
        for (int i = 1; i < 8; ++i) {
            min = new net.minecraft.world.phys.Vec3(Math.min(min.x, corners[i].x), Math.min(min.y, corners[i].y), Math.min(min.z, corners[i].z));
            max = new net.minecraft.world.phys.Vec3(Math.max(max.x, corners[i].x), Math.max(max.y, corners[i].y), Math.max(max.z, corners[i].z));
        }
        return new AABB(min, max);
    }

    public net.minecraft.world.phys.Vec3[] getCorners() {
        net.minecraft.world.phys.Vec3[] corners = new net.minecraft.world.phys.Vec3[]{this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.minX, this.localAABB.minY, this.localAABB.minZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.maxX, this.localAABB.minY, this.localAABB.minZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.maxX, this.localAABB.maxY, this.localAABB.minZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.minX, this.localAABB.maxY, this.localAABB.minZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.minX, this.localAABB.minY, this.localAABB.maxZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.maxX, this.localAABB.minY, this.localAABB.maxZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.maxX, this.localAABB.maxY, this.localAABB.maxZ)), this.transformToWorld(new net.minecraft.world.phys.Vec3(this.localAABB.minX, this.localAABB.maxY, this.localAABB.maxZ))};
        return corners;
    }

    private net.minecraft.world.phys.Vec3 transformToLocal(net.minecraft.world.phys.Vec3 worldPoint) {
        RVec3 center = this.transform.getTranslation();
        RVec3 p = new RVec3(worldPoint.x - center.xx(), worldPoint.y - center.yy(), worldPoint.z - center.zz());
        Quat inverseRotation = this.transform.getRotation().conjugated();
        RVec3 localPoint = new RVec3(p);
        localPoint.rotateInPlace(inverseRotation);
        return new net.minecraft.world.phys.Vec3(localPoint.xx(), localPoint.yy(), localPoint.zz());
    }

    private net.minecraft.world.phys.Vec3 transformToWorld(net.minecraft.world.phys.Vec3 localPoint) {
        RVec3 p = new RVec3(localPoint.x, localPoint.y, localPoint.z);
        RVec3 rotatedPoint = new RVec3(p);
        rotatedPoint.rotateInPlace(this.transform.getRotation());
        RVec3 center = this.transform.getTranslation();
        return new net.minecraft.world.phys.Vec3(rotatedPoint.xx() + center.xx(), rotatedPoint.yy() + center.yy(), rotatedPoint.zz() + center.zz());
    }

    private static net.minecraft.world.phys.Vec3 toMcVec3(Vec3 joltVec) {
        return new net.minecraft.world.phys.Vec3((double)joltVec.getX(), (double)joltVec.getY(), (double)joltVec.getZ());
    }

    private static double getComponent(net.minecraft.world.phys.Vec3 v, int index) {
        return switch (index) {
            case 0 -> v.x;
            case 1 -> v.y;
            case 2 -> v.z;
            default -> 0.0;
        };
    }

    public String toString() {
        return "VxOBB{transform=" + String.valueOf(this.transform) + ", localAABB=" + String.valueOf(this.localAABB) + "}";
    }
}

