/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.body;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.manager.VxNetworkDispatcher;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap_ChunkTracking {
    @Shadow
    @Final
    ServerLevel level;

    @Unique
    private VxNetworkDispatcher velthoric$getDispatcher() {
        VxBodyManager manager;
        VxPhysicsWorld world = VxPhysicsWorld.get((ResourceKey<Level>)this.level.dimension());
        if (world != null && (manager = world.getBodyManager()) != null) {
            return manager.getNetworkDispatcher();
        }
        return null;
    }

    @Inject(method={"markChunkPendingToSend(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/level/ChunkPos;)V"}, at={@At(value="TAIL")})
    private void velthoric$onMarkChunkPendingToSend(ServerPlayer player, ChunkPos chunkPos, CallbackInfo ci) {
        VxNetworkDispatcher dispatcher = this.velthoric$getDispatcher();
        if (dispatcher != null) {
            dispatcher.trackBodiesInChunkForPlayer(player, chunkPos);
        }
    }

    @Inject(method={"dropChunk(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/level/ChunkPos;)V"}, at={@At(value="HEAD")})
    private static void velthoric$onDropChunk(ServerPlayer player, ChunkPos chunkPos, CallbackInfo ci) {
        VxNetworkDispatcher dispatcher;
        VxBodyManager manager;
        ServerLevel serverLevel;
        VxPhysicsWorld world;
        Level level = player.level();
        if (level instanceof ServerLevel && (world = VxPhysicsWorld.get((ResourceKey<Level>)(serverLevel = (ServerLevel)level).dimension())) != null && (manager = world.getBodyManager()) != null && (dispatcher = manager.getNetworkDispatcher()) != null) {
            dispatcher.untrackBodiesInChunkForPlayer(player, chunkPos);
        }
    }

    @Inject(method={"updatePlayerStatus(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="TAIL")})
    private void velthoric$onPlayerLeave(ServerPlayer player, boolean track, CallbackInfo ci) {
        VxNetworkDispatcher dispatcher;
        if (!track && (dispatcher = this.velthoric$getDispatcher()) != null) {
            dispatcher.onPlayerDisconnect(player);
        }
    }
}

