/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.debug;

import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.debug.VxPhysicsDebugChart;
import net.xmx.velthoric.physics.body.client.time.VxFrameTimer;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugScreenOverlay.class})
public abstract class MixinDebugScreenOverlay {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private boolean renderFpsCharts;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="RETURN")})
    private void velthoric_renderPhysicsChart(GuiGraphics guiGraphics, CallbackInfo ci) {
        VxPhysicsWorld physicsWorld;
        if (this.renderFpsCharts && this.minecraft.level != null && (physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.minecraft.level.dimension())) != null) {
            VxFrameTimer frameTimer = physicsWorld.getPhysicsFrameTimer();
            int screenWidth = guiGraphics.guiWidth();
            int screenHeight = guiGraphics.guiHeight();
            int halfWidth = screenWidth / 2;
            int chartWidth = Math.min(halfWidth, 242);
            int xPos = screenWidth - chartWidth;
            int baseY = screenHeight - 75;
            ToIntFunction<Integer> colorSampler = height -> {
                float hue = (1.0f - (float)height.intValue() / 60.0f) / 3.0f;
                hue = Mth.clamp((float)hue, (float)0.0f, (float)0.33f);
                return Mth.hsvToRgb((float)hue, (float)1.0f, (float)1.0f) | 0xFF000000;
            };
            VxPhysicsDebugChart.draw(guiGraphics, this.minecraft.font, frameTimer, xPos, chartWidth, baseY, colorSampler);
        }
    }
}

