/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.entity;

import com.github.stephengold.joltjni.Quat;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Shadow
    private Level level;
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    public abstract float getEyeHeight();

    @Shadow
    public abstract Entity getVehicle();

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_getEyePositionOnPhysicsBody(float partialTicks, CallbackInfoReturnable<Vec3> cir) {
        Entity entity;
        if (!this.level.isClientSide() || !((entity = this.getVehicle()) instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)entity;
        VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, partialTicks, this.velthoric_interpolatedTransform).ifPresent(transform -> {
            Quat joltRotation = transform.getRotation();
            Quaterniond physRotation = new Quaterniond((double)joltRotation.getX(), (double)joltRotation.getY(), (double)joltRotation.getZ(), (double)joltRotation.getW());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            Vector3d playerBasePos = VxConversions.toJoml(transform.getTranslation(), new Vector3d()).add((double)rideOffset.x, (double)rideOffset.y, (double)rideOffset.z);
            Vector3d eyeOffset = new Vector3d(0.0, (double)this.getEyeHeight(), 0.0);
            physRotation.transform(eyeOffset);
            Vector3d finalEyePos = playerBasePos.add((Vector3dc)eyeOffset);
            cir.setReturnValue((Object)VxConversions.toMinecraft(finalEyePos));
        });
    }

    @Inject(method={"calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void velthoric_transformViewVector(float xRot, float yRot, CallbackInfoReturnable<Vec3> cir) {
        Entity self = (Entity)this;
        Entity entity = self.getVehicle();
        if (!(entity instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)entity;
        proxy.getPhysicsId().ifPresent(id -> {
            Quaterniond vehicleRotation;
            Vec3 localViewVector = (Vec3)cir.getReturnValue();
            Vector3d transformedVector = VxConversions.toJoml(localViewVector, new Vector3d());
            if (this.level.isClientSide()) {
                vehicleRotation = this.velthoric_getInterpolatedRotationClient(proxy).orElse(null);
                if (vehicleRotation == null) {
                    return;
                }
            } else {
                VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.level.dimension());
                if (physicsWorld == null) {
                    return;
                }
                VxBody body = physicsWorld.getBodyManager().getVxBody((UUID)id);
                if (body == null) {
                    return;
                }
                Quat rot = body.getTransform().getRotation();
                vehicleRotation = new Quaterniond((double)rot.getX(), (double)rot.getY(), (double)rot.getZ(), (double)rot.getW());
            }
            vehicleRotation.transform(transformedVector);
            cir.setReturnValue((Object)VxConversions.toMinecraft(transformedVector));
        });
    }

    @Unique
    @OnlyIn(value=Dist.CLIENT)
    private Optional<Quaterniond> velthoric_getInterpolatedRotationClient(VxMountingEntity proxy) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        return VxMountingRenderUtils.INSTANCE.getInterpolatedRotation(proxy, partialTicks).map(q -> new Quaterniond((double)q.getX(), (double)q.getY(), (double)q.getZ(), (double)q.getW()));
    }
}

