/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class MixinCamera {
    @Shadow
    @Final
    private Quaternionf rotation;
    @Shadow
    @Final
    private Vector3f forwards;
    @Shadow
    @Final
    private Vector3f up;
    @Shadow
    @Final
    private Vector3f left;
    @Shadow
    private boolean initialized;
    @Shadow
    private BlockGetter level;
    @Shadow
    private boolean detached;
    @Shadow
    private Entity entity;
    @Shadow
    private float eyeHeight;
    @Shadow
    private float eyeHeightOld;
    @Shadow
    private float yRot;
    @Shadow
    private float xRot;
    @Shadow
    private Vec3 position;
    @Unique
    private static final Vector3f FORWARDS_CONST = new Vector3f(0.0f, 0.0f, -1.0f);
    @Unique
    private static final Vector3f UP_CONST = new Vector3f(0.0f, 1.0f, 0.0f);
    @Unique
    private static final Vector3f LEFT_CONST = new Vector3f(-1.0f, 0.0f, 0.0f);
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    protected abstract void setPosition(double var1, double var3, double var5);

    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @Inject(method={"setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_followPhysicsBody(BlockGetter level, Entity focusedEntity, boolean detached, boolean thirdPersonReverse, float partialTick, CallbackInfo ci) {
        VxMountingEntity proxy;
        Optional<VxTransform> transformOpt;
        Entity entity = focusedEntity.getVehicle();
        if (entity instanceof VxMountingEntity && (transformOpt = VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy = (VxMountingEntity)entity, partialTick, this.velthoric_interpolatedTransform)).isPresent()) {
            VxTransform transform = transformOpt.get();
            Quaternionf physRotation = transform.getRotation(new Quaternionf());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            Vector3d playerBasePos = VxConversions.toJoml(transform.getTranslation(), new Vector3d()).add((double)rideOffset.x, (double)rideOffset.y, (double)rideOffset.z);
            double eyeY = Mth.lerp((float)partialTick, (float)this.eyeHeightOld, (float)this.eyeHeight);
            Vector3f eyeOffset = new Vector3f(0.0f, (float)eyeY, 0.0f);
            physRotation.transform(eyeOffset);
            Vector3d playerEyePos = playerBasePos.add((double)eyeOffset.x(), (double)eyeOffset.y(), (double)eyeOffset.z());
            this.initialized = true;
            this.level = level;
            this.entity = focusedEntity;
            this.detached = detached;
            this.setPosition(playerEyePos.x, playerEyePos.y, playerEyePos.z);
            float yaw = focusedEntity.getViewYRot(partialTick);
            float pitch = focusedEntity.getViewXRot(partialTick);
            if (detached) {
                if (thirdPersonReverse) {
                    yaw += 180.0f;
                    pitch = -pitch;
                }
                this.velthoric_setRotationWithPhysicsTransform(yaw, pitch, physRotation);
                float scale = 1.0f;
                if (focusedEntity instanceof LivingEntity) {
                    scale = ((LivingEntity)focusedEntity).getScale();
                }
                float zoomDistance = this.velthoric_getMaxZoom(4.0f * scale);
                this.move(-zoomDistance, 0.0f, 0.0f);
            } else {
                this.velthoric_setRotationWithPhysicsTransform(yaw, pitch, physRotation);
            }
            ci.cancel();
        }
    }

    @Unique
    private void velthoric_setRotationWithPhysicsTransform(float yaw, float pitch, Quaternionf physRotation) {
        this.xRot = pitch;
        this.yRot = yaw;
        Quaternionf localRotation = new Quaternionf().rotationYXZ((float)Math.PI - yaw * ((float)Math.PI / 180), -pitch * ((float)Math.PI / 180), 0.0f);
        Quaternionf finalRotation = new Quaternionf((Quaternionfc)physRotation).mul((Quaternionfc)localRotation);
        this.rotation.set((Quaternionfc)finalRotation);
        FORWARDS_CONST.rotate((Quaternionfc)this.rotation, this.forwards);
        UP_CONST.rotate((Quaternionfc)this.rotation, this.up);
        LEFT_CONST.rotate((Quaternionfc)this.rotation, this.left);
    }

    @Unique
    private float velthoric_getMaxZoom(float maxZoom) {
        for (int i = 0; i < 8; ++i) {
            float k;
            Vec3 vec32;
            float g = (i & 1) * 2 - 1;
            float h = (i >> 1 & 1) * 2 - 1;
            float j = (i >> 2 & 1) * 2 - 1;
            Vec3 vec3 = this.position.add((double)(g * 0.1f), (double)(h * 0.1f), (double)(j * 0.1f));
            BlockHitResult hitResult = this.level.clip(new ClipContext(vec3, vec32 = vec3.add(new Vec3(this.forwards).scale((double)(-maxZoom))), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.entity));
            if (hitResult.getType() == HitResult.Type.MISS || !((k = (float)hitResult.getLocation().distanceToSqr(this.position)) < Mth.square((float)maxZoom))) continue;
            maxZoom = Mth.sqrt((float)k);
        }
        return maxZoom;
    }
}

