/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class MixinEntityRenderDispatcher {
    @Inject(method={"render(Lnet/minecraft/world/entity/Entity;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderer;render(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", shift=At.Shift.BEFORE)})
    private <E extends Entity> void velthoric_applyFullEntityTransform(E entity, double x, double y, double z, float rotationYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        VxMountingRenderUtils.INSTANCE.ifMountedOnBody(entity, partialTicks, physQuat -> {
            Quaternionf physRotation = VxConversions.toJoml(physQuat, new Quaternionf());
            poseStack.mulPose(physRotation);
        });
    }

    @Redirect(method={"renderHitbox(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;FFFF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 velthoric_redirectViewVectorForHitbox(Entity instance, float partialTicks) {
        Vec3 originalViewVector = instance.getViewVector(partialTicks);
        Entity entity = instance.getVehicle();
        if (entity instanceof VxMountingEntity) {
            VxMountingEntity proxy = (VxMountingEntity)entity;
            return VxMountingRenderUtils.INSTANCE.getInterpolatedRotation(proxy, partialTicks).map(physQuat -> {
                Quaterniond physRotation = new Quaterniond((double)physQuat.getX(), (double)physQuat.getY(), (double)physQuat.getZ(), (double)physQuat.getW());
                physRotation.invert();
                Vector3d correctedVector = VxConversions.toJoml(originalViewVector, new Vector3d());
                physRotation.transform(correctedVector);
                return VxConversions.toMinecraft(correctedVector);
            }).orElse(originalViewVector);
        }
        return originalViewVector;
    }
}

