/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntityState;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    Minecraft minecraft;
    @Shadow
    @Final
    private Camera mainCamera;
    @Unique
    private final Map<Integer, VxMountingEntityState> velthoric_originalStates = new HashMap<Integer, VxMountingEntityState>();
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    protected abstract double getFov(Camera var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f getProjectionMatrix(double var1);

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(DeltaTracker deltaTracker, CallbackInfo ci) {
        ClientLevel clientWorld = this.minecraft.level;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (Entity entity : clientWorld.entitiesForRendering()) {
            Entity passenger;
            VxMountingEntity proxy;
            if (!(entity instanceof VxMountingEntity) || (proxy = (VxMountingEntity)entity).getPassengers().isEmpty() || (passenger = proxy.getFirstPassenger()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, deltaTracker.getGameTimeDeltaPartialTick(true));
            this.velthoric_adjustEntityForRender(passenger, deltaTracker.getGameTimeDeltaPartialTick(true));
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(Entity entity, float tickDelta) {
        VxMountingEntity proxy;
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof VxMountingEntity) {
            VxMountingEntity vehicleProxy;
            proxy = vehicleProxy = (VxMountingEntity)entity2;
        } else if (entity instanceof VxMountingEntity) {
            VxMountingEntity selfProxy;
            proxy = selfProxy = (VxMountingEntity)entity;
        } else {
            return;
        }
        VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, tickDelta, this.velthoric_interpolatedTransform).ifPresent(transform -> {
            this.velthoric_originalStates.computeIfAbsent(entity.getId(), k -> new VxMountingEntityState()).setFrom(entity);
            Quaternionf physRotation = transform.getRotation(new Quaternionf());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            double targetX = transform.getTranslation().xx() + (double)rideOffset.x();
            double targetY = transform.getTranslation().yy() + (double)rideOffset.y();
            double targetZ = transform.getTranslation().zz() + (double)rideOffset.z();
            entity.setPos(targetX, targetY, targetZ);
            entity.xo = targetX;
            entity.yo = targetY;
            entity.zo = targetZ;
            entity.xOld = targetX;
            entity.yOld = targetY;
            entity.zOld = targetZ;
        });
    }

    @Inject(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="RETURN")})
    private void velthoric_postRenderLevel(DeltaTracker deltaTracker, CallbackInfo ci) {
        ClientLevel clientWorld = this.minecraft.level;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            Entity entity = clientWorld.getEntity(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }

    @WrapOperation(method={"renderLevel(Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V")})
    private void velthoric_setupCameraWithPhysicsBody(LevelRenderer instance, Vec3 cameraPos, Matrix4f viewMatrix, Matrix4f projectionMatrix, Operation<Void> original) {
        LocalPlayer player = this.minecraft.player;
        if (player != null) {
            float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
            boolean[] handled = new boolean[]{false};
            VxMountingRenderUtils.INSTANCE.ifMountedOnBody((Entity)player, partialTicks, physQuat -> {
                double fov = this.getFov(this.mainCamera, partialTicks, true);
                Matrix4f newProjectionMatrix = this.getProjectionMatrix(Math.max(fov, (double)((Integer)this.minecraft.options.fov().get()).intValue()));
                original.call(new Object[]{instance, cameraPos, viewMatrix, newProjectionMatrix});
                handled[0] = true;
            });
            if (handled[0]) {
                return;
            }
        }
        original.call(new Object[]{instance, cameraPos, viewMatrix, projectionMatrix});
    }

    @WrapOperation(method={"pick(F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;pick(Lnet/minecraft/world/entity/Entity;DDF)Lnet/minecraft/world/phys/HitResult;")})
    private HitResult velthoric_wrapPick(GameRenderer instance, Entity entity, double blockReach, double entityReach, float partialTicks, Operation<HitResult> original) {
        AABB searchBox;
        Vec3 viewVector;
        Vec3 reachVec;
        Vec3 eyePos;
        EntityHitResult obbResult;
        HitResult vanillaResult = (HitResult)original.call(new Object[]{instance, entity, blockReach, entityReach, Float.valueOf(partialTicks)});
        if (!(vanillaResult instanceof EntityHitResult) && (obbResult = this.velthoric_pickMountedEntities(entity, eyePos = entity.getEyePosition(partialTicks), reachVec = eyePos.add((viewVector = entity.getViewVector(partialTicks)).scale(entityReach)), searchBox = entity.getBoundingBox().expandTowards(viewVector.scale(entityReach)).inflate(1.0), entityReach * entityReach)) != null) {
            return obbResult;
        }
        return vanillaResult;
    }

    @Unique
    private EntityHitResult velthoric_pickMountedEntities(Entity shooter, Vec3 start, Vec3 end, AABB searchBox, double maxDistanceSq) {
        double closestDistSq = maxDistanceSq;
        EntityHitResult bestResult = null;
        List potentialTargets = this.minecraft.level.getEntities(shooter, searchBox, e -> !e.isSpectator() && e.isPickable());
        for (Entity target : potentialTargets) {
            double distSq;
            Optional<EntityHitResult> obbHit;
            if (!(target.getVehicle() instanceof VxMountingEntity) || !(obbHit = this.velthoric_performObbRaycast(target, start, end)).isPresent() || !((distSq = start.distanceToSqr(obbHit.get().getLocation())) < closestDistSq)) continue;
            closestDistSq = distSq;
            bestResult = obbHit.get();
        }
        return bestResult;
    }

    @Unique
    private Optional<EntityHitResult> velthoric_performObbRaycast(Entity target, Vec3 start, Vec3 end) {
        Entity entity = target.getVehicle();
        if (!(entity instanceof VxMountingEntity)) {
            return Optional.empty();
        }
        VxMountingEntity proxy = (VxMountingEntity)entity;
        return this.velthoric_createTargetOBB(target, proxy).flatMap(obb -> obb.clip(start, end)).map(hitPos -> new EntityHitResult(target, hitPos));
    }

    @Unique
    private Optional<VxOBB> velthoric_createTargetOBB(Entity target, VxMountingEntity proxy) {
        float partialTicks = this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        return VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, partialTicks, this.velthoric_interpolatedTransform).map(transform -> {
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            transform.getRotation(new Quaternionf()).transform(rideOffset);
            transform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            AABB targetAABB = target.getBoundingBox().inflate((double)target.getPickRadius());
            AABB localEntityAABB = targetAABB.move(-target.getX(), -target.getY(), -target.getZ());
            return new VxOBB((VxTransform)transform, localEntityAABB);
        });
    }
}

