/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.request;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.request.C2SRequestMountPacket;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft {
    @Shadow
    public LocalPlayer player;
    @Unique
    private final VxRenderState velthoric_renderState = new VxRenderState();
    @Unique
    private final RVec3 velthoric_tempPos = new RVec3();
    @Unique
    private final Quat velthoric_tempRot = new Quat();

    @Inject(method={"handleKeybinds()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void velthoric_handleRideInteraction(CallbackInfo ci) {
        if (Minecraft.getInstance().options.keyUse.consumeClick() && this.velthoric_performSeatRaycast()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean velthoric_performSeatRaycast() {
        if (this.player == null || this.player.isPassenger()) {
            return false;
        }
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        double maxDist = this.player.isCreative() ? 5.0 : 4.5;
        Vec3 cameraPos = this.player.getEyePosition(partialTicks);
        Vec3 viewVec = this.player.getViewVector(partialTicks);
        Vec3 endVec = cameraPos.add(viewVec.x * maxDist, viewVec.y * maxDist, viewVec.z * maxDist);
        VxClientBodyManager bodyManager = VxClientBodyManager.getInstance();
        VxClientMountingManager ridingManager = VxClientMountingManager.INSTANCE;
        VxBody closestBody = null;
        VxSeat closestSeat = null;
        double closestDistSq = Double.MAX_VALUE;
        for (VxBody body : bodyManager.getAllBodies()) {
            if (!body.isInitialized()) continue;
            body.calculateRenderState(partialTicks, this.velthoric_renderState, this.velthoric_tempPos, this.velthoric_tempRot);
            for (VxSeat seat : ridingManager.getSeats(body.getPhysicsId())) {
                double distSq;
                VxOBB narrowPhaseBox;
                Optional<Vec3> hitPos;
                AABB broadPhaseBox = seat.getGlobalAABB(this.velthoric_renderState.transform);
                if (!broadPhaseBox.clip(cameraPos, endVec).isPresent() || !(hitPos = (narrowPhaseBox = seat.getGlobalOBB(this.velthoric_renderState.transform)).clip(cameraPos, endVec)).isPresent() || !((distSq = cameraPos.distanceToSqr(hitPos.get())) < closestDistSq)) continue;
                closestDistSq = distSq;
                closestBody = body;
                closestSeat = seat;
            }
        }
        if (closestBody != null) {
            VxPacketHandler.sendToServer(new C2SRequestMountPacket(closestBody.getPhysicsId(), closestSeat.getId()));
            return true;
        }
        return false;
    }
}

