/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.physicsgun;

import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.xmx.velthoric.init.registry.ItemRegistry;
import net.xmx.velthoric.item.physicsgun.manager.VxPhysicsGunClientManager;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunActionPacket;
import net.xmx.velthoric.network.VxPacketHandler;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class}, priority=1100)
public class MouseHandlerMixin_PhysicsGunHandling {
    @Shadow
    private double accumulatedDX;
    @Shadow
    private double accumulatedDY;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"turnPlayer(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTurnPlayer(CallbackInfo ci) {
        VxPhysicsGunClientManager clientManager = VxPhysicsGunClientManager.getInstance();
        if (clientManager.isRotationMode()) {
            if (this.accumulatedDX != 0.0 || this.accumulatedDY != 0.0) {
                VxPacketHandler.sendToServer(new VxPhysicsGunActionPacket((float)this.accumulatedDX, (float)this.accumulatedDY));
            }
            this.accumulatedDX = 0.0;
            this.accumulatedDY = 0.0;
            ci.cancel();
        }
    }

    @Inject(method={"onPress(JIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseButtonPress(long window, int button, int action, int mods, CallbackInfo ci) {
        boolean isHoldingGun;
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        VxPhysicsGunClientManager clientManager = VxPhysicsGunClientManager.getInstance();
        boolean bl = isHoldingGun = player.getMainHandItem().is((Item)ItemRegistry.PHYSICS_GUN.get()) || player.getOffhandItem().is((Item)ItemRegistry.PHYSICS_GUN.get());
        if (this.minecraft.screen != null) {
            if (isHoldingGun && clientManager.isTryingToGrab((Player)player)) {
                clientManager.stopGrabAttempt();
            }
            return;
        }
        if (!isHoldingGun) {
            if (clientManager.isTryingToGrab((Player)player)) {
                clientManager.stopGrabAttempt();
            }
            return;
        }
        boolean eventHandled = false;
        if (button == 0) {
            if (action == 1) {
                clientManager.startGrabAttempt();
            } else if (action == 0) {
                clientManager.stopGrabAttempt();
            }
            eventHandled = true;
        }
        if (button == 1) {
            if (action == 1) {
                VxPacketHandler.sendToServer(new VxPhysicsGunActionPacket(VxPhysicsGunActionPacket.ActionType.FREEZE_OBJECT));
            }
            eventHandled = true;
        }
        if (eventHandled) {
            ci.cancel();
        }
    }

    @Inject(method={"onScroll(JDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseScroll(long window, double horizontal, double vertical, CallbackInfo ci) {
        boolean isGrabbing;
        boolean isHoldingGun;
        LocalPlayer player = this.minecraft.player;
        if (player == null || this.minecraft.screen != null) {
            return;
        }
        boolean bl = isHoldingGun = player.getMainHandItem().is((Item)ItemRegistry.PHYSICS_GUN.get()) || player.getOffhandItem().is((Item)ItemRegistry.PHYSICS_GUN.get());
        if (!isHoldingGun) {
            return;
        }
        boolean bl2 = isGrabbing = GLFW.glfwGetMouseButton((long)this.minecraft.getWindow().getWindow(), (int)0) == 1;
        if (isGrabbing) {
            VxPacketHandler.sendToServer(new VxPhysicsGunActionPacket((float)vertical));
            ci.cancel();
        }
    }
}

