/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.GameInstance;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.xmx.velthoric.item.boxthrower.packet.VxBoxThrowerActionPacket;
import net.xmx.velthoric.item.chaincreator.packet.VxChainCreatorActionPacket;
import net.xmx.velthoric.item.magnetizer.packet.VxMagnetizerActionPacket;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunActionPacket;
import net.xmx.velthoric.item.physicsgun.packet.VxPhysicsGunSyncPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CRemoveBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSpawnBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSynchronizedDataBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateBodyStateBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateVerticesBatchPacket;
import net.xmx.velthoric.physics.mounting.input.C2SMountInputPacket;
import net.xmx.velthoric.physics.mounting.request.C2SRequestMountPacket;
import net.xmx.velthoric.physics.vehicle.sync.S2CVehicleStatePacket;

public class VxPacketHandler {
    private static final String CHANNEL_NAMESPACE = "velthoric";
    private static final Map<Class<?>, PacketInfo<?>> PACKETS = new HashMap();

    private static <T> void registerPacket(Class<T> type, String name, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkManager.PacketContext>> handler, NetworkManager.Side side) {
        ResourceLocation id = ResourceLocation.tryBuild((String)CHANNEL_NAMESPACE, (String)name);
        CustomPacketPayload.Type payloadType = new CustomPacketPayload.Type(id);
        PACKETS.put(type, new PacketInfo(payloadType));
        StreamCodec codec = StreamCodec.of((buf, wrapper) -> encoder.accept(wrapper.message(), (FriendlyByteBuf)buf), buf -> new PacketWrapper(decoder.apply((FriendlyByteBuf)buf), payloadType));
        NetworkManager.NetworkReceiver receiver = (wrapper, context) -> handler.accept(wrapper.message(), () -> context);
        if (side == NetworkManager.Side.C2S) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, (CustomPacketPayload.Type)payloadType, (StreamCodec)codec, (NetworkManager.NetworkReceiver)receiver);
        } else if (Platform.getEnv() == Dist.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)side, (CustomPacketPayload.Type)payloadType, (StreamCodec)codec, (NetworkManager.NetworkReceiver)receiver);
        } else {
            NetworkManager.registerS2CPayloadType((CustomPacketPayload.Type)payloadType, (StreamCodec)codec);
        }
    }

    public static void register() {
        VxPacketHandler.registerPacket(VxChainCreatorActionPacket.class, "chain_creator_action", VxChainCreatorActionPacket::encode, VxChainCreatorActionPacket::decode, VxChainCreatorActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(C2SRequestMountPacket.class, "request_mount", C2SRequestMountPacket::encode, C2SRequestMountPacket::decode, C2SRequestMountPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(C2SMountInputPacket.class, "mount_input", C2SMountInputPacket::encode, C2SMountInputPacket::decode, C2SMountInputPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(VxMagnetizerActionPacket.class, "magnetizer_action", VxMagnetizerActionPacket::encode, VxMagnetizerActionPacket::decode, VxMagnetizerActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(VxPhysicsGunActionPacket.class, "physics_gun_action", VxPhysicsGunActionPacket::encode, VxPhysicsGunActionPacket::decode, VxPhysicsGunActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(VxBoxThrowerActionPacket.class, "box_thrower_action", VxBoxThrowerActionPacket::encode, VxBoxThrowerActionPacket::decode, VxBoxThrowerActionPacket::handle, NetworkManager.Side.C2S);
        VxPacketHandler.registerPacket(S2CSynchronizedDataBatchPacket.class, "sync_data_batch", S2CSynchronizedDataBatchPacket::encode, S2CSynchronizedDataBatchPacket::decode, S2CSynchronizedDataBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CVehicleStatePacket.class, "vehicle_state", S2CVehicleStatePacket::encode, S2CVehicleStatePacket::decode, S2CVehicleStatePacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CSpawnBodyBatchPacket.class, "spawn_body_batch", S2CSpawnBodyBatchPacket::encode, S2CSpawnBodyBatchPacket::decode, S2CSpawnBodyBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CRemoveBodyBatchPacket.class, "remove_body_batch", S2CRemoveBodyBatchPacket::encode, S2CRemoveBodyBatchPacket::decode, S2CRemoveBodyBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CUpdateBodyStateBatchPacket.class, "update_body_state_batch", S2CUpdateBodyStateBatchPacket::encode, S2CUpdateBodyStateBatchPacket::decode, S2CUpdateBodyStateBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(S2CUpdateVerticesBatchPacket.class, "update_vertices_batch", S2CUpdateVerticesBatchPacket::encode, S2CUpdateVerticesBatchPacket::decode, S2CUpdateVerticesBatchPacket::handle, NetworkManager.Side.S2C);
        VxPacketHandler.registerPacket(VxPhysicsGunSyncPacket.class, "physics_gun_sync", VxPhysicsGunSyncPacket::encode, VxPhysicsGunSyncPacket::decode, VxPhysicsGunSyncPacket::handle, NetworkManager.Side.S2C);
    }

    private static <MSG> PacketInfo<MSG> getPacketInfo(MSG message) {
        PacketInfo<?> info = PACKETS.get(message.getClass());
        return Objects.requireNonNull(info, "Unregistered packet type: " + message.getClass().getName());
    }

    public static <MSG> void sendToServer(MSG message) {
        PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
        NetworkManager.sendToServer(new PacketWrapper<MSG>(message, info.type()));
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
        NetworkManager.sendToPlayer((ServerPlayer)player, new PacketWrapper<MSG>(message, info.type()));
    }

    public static <MSG> void sendToDimension(MSG message, ResourceKey<Level> dimensionKey) {
        ServerLevel level;
        if (GameInstance.getServer() != null && (level = GameInstance.getServer().getLevel(dimensionKey)) != null) {
            PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
            NetworkManager.sendToPlayers((Iterable)level.players(), new PacketWrapper<MSG>(message, info.type()));
        }
    }

    public static <MSG> void sendToAll(MSG message) {
        if (GameInstance.getServer() != null) {
            PacketInfo<MSG> info = VxPacketHandler.getPacketInfo(message);
            NetworkManager.sendToPlayers((Iterable)GameInstance.getServer().getPlayerList().getPlayers(), new PacketWrapper<MSG>(message, info.type()));
        }
    }

    private record PacketInfo<T>(CustomPacketPayload.Type<PacketWrapper<T>> type) {
    }

    private record PacketWrapper<T>(T message, CustomPacketPayload.Type<PacketWrapper<T>> type) implements CustomPacketPayload
    {
    }
}

