/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.network;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import java.io.IOException;
import java.util.Arrays;

public class VxPacketUtils {
    private static final int COMPRESSION_LEVEL = 3;
    private static final ThreadLocal<ZstdCompressCtx> COMPRESS_CTX = ThreadLocal.withInitial(() -> new ZstdCompressCtx().setLevel(3));
    private static final ThreadLocal<ZstdDecompressCtx> DECOMPRESS_CTX = ThreadLocal.withInitial(ZstdDecompressCtx::new);

    public static byte[] compress(byte[] data) throws IOException {
        ZstdCompressCtx ctx = COMPRESS_CTX.get();
        long maxCompressedSize = Zstd.compressBound(data.length);
        if (maxCompressedSize > Integer.MAX_VALUE) {
            throw new IOException("Data is too large to compress.");
        }
        byte[] compressed = new byte[(int)maxCompressedSize];
        long compressedSize = ctx.compress(compressed, data);
        if (Zstd.isError(compressedSize)) {
            throw new IOException("Zstd compression failed: " + Zstd.getErrorName(compressedSize));
        }
        return Arrays.copyOf(compressed, (int)compressedSize);
    }

    public static byte[] decompress(byte[] data, int uncompressedSize) throws IOException {
        byte[] decompressed;
        ZstdDecompressCtx ctx = DECOMPRESS_CTX.get();
        long decompressedSize = ctx.decompress(decompressed = new byte[uncompressedSize], data);
        if (Zstd.isError(decompressedSize)) {
            throw new IOException("Zstd decompression failed: " + Zstd.getErrorName(decompressedSize));
        }
        if (decompressedSize != (long)uncompressedSize) {
            throw new IOException("Decompressed size mismatch. Expected " + uncompressedSize + ", got " + decompressedSize);
        }
        return decompressed;
    }
}

