/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.UUID;
import net.minecraft.util.Mth;
import net.xmx.velthoric.math.VxOperations;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import org.jetbrains.annotations.Nullable;

public class VxClientBodyInterpolator {
    private static final float MAX_EXTRAPOLATION_SECONDS = 1.25f;
    private static final float EXTRAPOLATION_VELOCITY_THRESHOLD_SQ = 1.0E-4f;
    private final Quat tempFromRot = new Quat();
    private final Quat tempToRot = new Quat();
    private final Quat tempRenderRot = new Quat();

    public void updateInterpolationTargets(VxClientBodyDataStore store, long renderTimestamp) {
        for (UUID id : store.getAllPhysicsIds()) {
            Integer i = store.getIndexForId(id);
            if (i == null || store.state1_timestamp[i] == 0L) continue;
            store.prev_posX[i.intValue()] = store.render_posX[i];
            store.prev_posY[i.intValue()] = store.render_posY[i];
            store.prev_posZ[i.intValue()] = store.render_posZ[i];
            store.prev_rotX[i.intValue()] = store.render_rotX[i];
            store.prev_rotY[i.intValue()] = store.render_rotY[i];
            store.prev_rotZ[i.intValue()] = store.render_rotZ[i];
            store.prev_rotW[i.intValue()] = store.render_rotW[i];
            if (store.render_vertexData[i] != null) {
                if (store.prev_vertexData[i] == null || store.prev_vertexData[i].length != store.render_vertexData[i].length) {
                    store.prev_vertexData[i.intValue()] = new float[store.render_vertexData[i].length];
                }
                System.arraycopy(store.render_vertexData[i], 0, store.prev_vertexData[i], 0, store.render_vertexData[i].length);
            } else {
                store.prev_vertexData[i.intValue()] = null;
            }
            this.calculateInterpolatedState(store, i, renderTimestamp);
            if (store.render_isInitialized[i]) continue;
            store.prev_posX[i.intValue()] = store.render_posX[i];
            store.prev_posY[i.intValue()] = store.render_posY[i];
            store.prev_posZ[i.intValue()] = store.render_posZ[i];
            store.prev_rotX[i.intValue()] = store.render_rotX[i];
            store.prev_rotY[i.intValue()] = store.render_rotY[i];
            store.prev_rotZ[i.intValue()] = store.render_rotZ[i];
            store.prev_rotW[i.intValue()] = store.render_rotW[i];
            if (store.render_vertexData[i] != null) {
                if (store.prev_vertexData[i] == null || store.prev_vertexData[i].length != store.render_vertexData[i].length) {
                    store.prev_vertexData[i.intValue()] = new float[store.render_vertexData[i].length];
                }
                System.arraycopy(store.render_vertexData[i], 0, store.prev_vertexData[i], 0, store.render_vertexData[i].length);
            }
            store.render_isInitialized[i.intValue()] = true;
        }
    }

    private void calculateInterpolatedState(VxClientBodyDataStore store, int i, long renderTimestamp) {
        if (!store.state1_isActive[i]) {
            this.setRenderStateToLatest(store, i);
            return;
        }
        long fromTime = store.state0_timestamp[i];
        long toTime = store.state1_timestamp[i];
        if (fromTime == 0L || toTime <= fromTime) {
            this.setRenderStateToLatest(store, i);
            return;
        }
        long timeDiff = toTime - fromTime;
        float alpha = (float)(renderTimestamp - fromTime) / (float)timeDiff;
        if (alpha > 1.0f) {
            float extrapolationTime = (float)(renderTimestamp - toTime) / 1.0E9f;
            float velX = store.state1_velX[i];
            float velY = store.state1_velY[i];
            float velZ = store.state1_velZ[i];
            float velSq = velX * velX + velY * velY + velZ * velZ;
            if (extrapolationTime < 1.25f && velSq > 1.0E-4f) {
                store.render_posX[i] = store.state1_posX[i] + velX * extrapolationTime;
                store.render_posY[i] = store.state1_posY[i] + velY * extrapolationTime;
                store.render_posZ[i] = store.state1_posZ[i] + velZ * extrapolationTime;
            } else {
                store.render_posX[i] = store.state1_posX[i];
                store.render_posY[i] = store.state1_posY[i];
                store.render_posZ[i] = store.state1_posZ[i];
            }
            store.render_rotX[i] = store.state1_rotX[i];
            store.render_rotY[i] = store.state1_rotY[i];
            store.render_rotZ[i] = store.state1_rotZ[i];
            store.render_rotW[i] = store.state1_rotW[i];
            store.render_vertexData[i] = store.state1_vertexData[i];
            return;
        }
        alpha = Math.max(0.0f, alpha);
        store.render_posX[i] = Mth.lerp((float)alpha, (float)store.state0_posX[i], (float)store.state1_posX[i]);
        store.render_posY[i] = Mth.lerp((float)alpha, (float)store.state0_posY[i], (float)store.state1_posY[i]);
        store.render_posZ[i] = Mth.lerp((float)alpha, (float)store.state0_posZ[i], (float)store.state1_posZ[i]);
        this.tempFromRot.set(store.state0_rotX[i], store.state0_rotY[i], store.state0_rotZ[i], store.state0_rotW[i]);
        this.tempToRot.set(store.state1_rotX[i], store.state1_rotY[i], store.state1_rotZ[i], store.state1_rotW[i]);
        VxOperations.slerp(this.tempFromRot, this.tempToRot, alpha, this.tempRenderRot);
        store.render_rotX[i] = this.tempRenderRot.getX();
        store.render_rotY[i] = this.tempRenderRot.getY();
        store.render_rotZ[i] = this.tempRenderRot.getZ();
        store.render_rotW[i] = this.tempRenderRot.getW();
        float[] fromVerts = store.state0_vertexData[i];
        float[] toVerts = store.state1_vertexData[i];
        if (fromVerts != null && toVerts != null && fromVerts.length == toVerts.length) {
            if (store.render_vertexData[i] == null || store.render_vertexData[i].length != toVerts.length) {
                store.render_vertexData[i] = new float[toVerts.length];
            }
            for (int j = 0; j < toVerts.length; ++j) {
                store.render_vertexData[i][j] = Mth.lerp((float)alpha, (float)fromVerts[j], (float)toVerts[j]);
            }
        } else {
            store.render_vertexData[i] = toVerts != null ? toVerts : fromVerts;
        }
    }

    private void setRenderStateToLatest(VxClientBodyDataStore store, int i) {
        store.render_posX[i] = store.state1_posX[i];
        store.render_posY[i] = store.state1_posY[i];
        store.render_posZ[i] = store.state1_posZ[i];
        store.render_rotX[i] = store.state1_rotX[i];
        store.render_rotY[i] = store.state1_rotY[i];
        store.render_rotZ[i] = store.state1_rotZ[i];
        store.render_rotW[i] = store.state1_rotW[i];
        store.render_vertexData[i] = store.state1_vertexData[i] != null ? store.state1_vertexData[i] : store.state0_vertexData[i];
    }

    public void interpolateFrame(VxClientBodyDataStore store, int i, float partialTicks, RVec3 outPos, Quat outRot) {
        this.interpolatePosition(store, i, partialTicks, outPos);
        this.interpolateRotation(store, i, partialTicks, outRot);
    }

    public void interpolatePosition(VxClientBodyDataStore store, int i, float partialTicks, RVec3 outPos) {
        outPos.set(Mth.lerp((float)partialTicks, (float)store.prev_posX[i], (float)store.render_posX[i]), Mth.lerp((float)partialTicks, (float)store.prev_posY[i], (float)store.render_posY[i]), Mth.lerp((float)partialTicks, (float)store.prev_posZ[i], (float)store.render_posZ[i]));
    }

    public void interpolateRotation(VxClientBodyDataStore store, int i, float partialTicks, Quat outRot) {
        this.tempFromRot.set(store.prev_rotX[i], store.prev_rotY[i], store.prev_rotZ[i], store.prev_rotW[i]);
        this.tempToRot.set(store.render_rotX[i], store.render_rotY[i], store.render_rotZ[i], store.render_rotW[i]);
        VxOperations.slerp(this.tempFromRot, this.tempToRot, partialTicks, outRot);
    }

    public float @Nullable [] getInterpolatedVertexData(VxClientBodyDataStore store, int i, float partialTicks) {
        float[] prevVerts = store.prev_vertexData[i];
        float[] currVerts = store.render_vertexData[i];
        if (currVerts == null) {
            return null;
        }
        if (prevVerts == null || prevVerts.length != currVerts.length) {
            return currVerts;
        }
        float[] outVerts = new float[currVerts.length];
        for (int j = 0; j < currVerts.length; ++j) {
            outVerts[j] = Mth.lerp((float)partialTicks, (float)prevVerts[j], (float)currVerts[j]);
        }
        return outVerts;
    }
}

