/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client.time;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum VxClientClock {
    INSTANCE;

    private volatile boolean isPaused = false;
    private long pauseStartTimeNanos = 0L;
    private long totalAccumulatedPauseTimeNanos = 0L;

    public synchronized long getGameTimeNanos() {
        if (this.isPaused) {
            return this.pauseStartTimeNanos - this.totalAccumulatedPauseTimeNanos;
        }
        return System.nanoTime() - this.totalAccumulatedPauseTimeNanos;
    }

    public synchronized void pause() {
        if (!this.isPaused) {
            this.isPaused = true;
            this.pauseStartTimeNanos = System.nanoTime();
        }
    }

    public synchronized void resume() {
        if (this.isPaused) {
            long pauseDuration = System.nanoTime() - this.pauseStartTimeNanos;
            this.totalAccumulatedPauseTimeNanos += pauseDuration;
            this.isPaused = false;
        }
    }

    public synchronized void reset() {
        this.isPaused = false;
        this.pauseStartTimeNanos = 0L;
        this.totalAccumulatedPauseTimeNanos = 0L;
    }
}

