/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.client.time;

public final class VxFrameTimer {
    private static final int HISTORY_LENGTH = 240;
    private final long[] frameTimes = new long[240];
    private int startIndex = 0;
    private int logLength = 0;
    private int currentIndex = 0;

    public void logFrameDuration(long frameDurationNanos) {
        this.frameTimes[this.currentIndex] = frameDurationNanos;
        this.currentIndex = (this.currentIndex + 1) % 240;
        if (this.logLength < 240) {
            ++this.logLength;
        } else {
            this.startIndex = (this.startIndex + 1) % 240;
        }
    }

    public void reset() {
        this.startIndex = 0;
        this.logLength = 0;
        this.currentIndex = 0;
    }

    public int scaleSampleTo(long durationNanos, int targetHeight, int referenceTps) {
        double nanosecondsPerTick = 1.0E9 / (double)referenceTps;
        double performanceRatio = (double)durationNanos / nanosecondsPerTick;
        return (int)(performanceRatio * (double)targetHeight);
    }

    public int getLogStart() {
        return this.startIndex;
    }

    public int getLogEnd() {
        return this.currentIndex;
    }

    public int wrapIndex(int index) {
        return (index % 240 + 240) % 240;
    }

    public long[] getLog() {
        return this.frameTimes;
    }

    public int getFrameCount() {
        return this.logLength;
    }
}

