/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.network.VxPacketHandler;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.packet.VxSpawnData;
import net.xmx.velthoric.physics.body.packet.batch.S2CRemoveBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSpawnBodyBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CSynchronizedDataBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateBodyStateBatchPacket;
import net.xmx.velthoric.physics.body.packet.batch.S2CUpdateVerticesBatchPacket;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.vehicle.sync.VxVehicleNetworkDispatcher;

public class VxNetworkDispatcher {
    private final ServerLevel level;
    private final VxBodyManager manager;
    private final VxBodyDataStore dataStore;
    private final VxVehicleNetworkDispatcher vehicleDispatcher;
    private static final int NETWORK_THREAD_TICK_RATE_MS = 10;
    private static final int MAX_STATES_PER_PACKET = 50;
    private static final int MAX_VERTICES_PER_PACKET = 50;
    private static final int MAX_PACKET_PAYLOAD_SIZE = 131072;
    private static final int MAX_REMOVALS_PER_PACKET = 512;
    private final Map<UUID, IntSet> playerTrackedBodies = new ConcurrentHashMap<UUID, IntSet>();
    private final Int2ObjectMap<Set<ServerPlayer>> bodyTrackers = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final Map<ServerPlayer, ObjectArrayList<VxSpawnData>> pendingSpawns = new HashMap<ServerPlayer, ObjectArrayList<VxSpawnData>>();
    private final Map<ServerPlayer, IntArrayList> pendingRemovals = new HashMap<ServerPlayer, IntArrayList>();
    private ExecutorService networkSyncExecutor;
    private static final ThreadLocal<VxByteBuf> THREAD_LOCAL_BYTE_BUF = ThreadLocal.withInitial(() -> new VxByteBuf(Unpooled.buffer((int)1024)));

    public VxNetworkDispatcher(ServerLevel level, VxBodyManager manager) {
        this.level = level;
        this.manager = manager;
        this.dataStore = manager.getDataStore();
        this.vehicleDispatcher = new VxVehicleNetworkDispatcher();
    }

    public VxBodyManager getManager() {
        return this.manager;
    }

    public void start() {
        this.networkSyncExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, "Velthoric-Network-Sync-Thread"));
        this.networkSyncExecutor.submit(this::runSyncLoop);
    }

    public void stop() {
        if (this.networkSyncExecutor != null) {
            this.networkSyncExecutor.shutdownNow();
        }
    }

    public void onGameTick() {
        this.processPendingRemovals();
        this.processPendingSpawns();
    }

    private void runSyncLoop() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                long cycleStartTime = System.nanoTime();
                this.sendStateUpdates();
                this.sendSynchronizedDataUpdates();
                this.vehicleDispatcher.dispatchUpdates(this.level, this.manager, (Map<Integer, Set<ServerPlayer>>)this.bodyTrackers);
                long cycleEndTime = System.nanoTime();
                long cycleDurationMs = (cycleEndTime - cycleStartTime) / 1000000L;
                long sleepTime = Math.max(0L, 10L - cycleDurationMs);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Exception in Velthoric Network Sync Thread", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateUpdates() {
        IntArrayList dirtyTransformIndices = new IntArrayList();
        IntArrayList dirtyVertexIndices = new IntArrayList();
        VxBodyDataStore vxBodyDataStore = this.dataStore;
        synchronized (vxBodyDataStore) {
            for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
                if (this.dataStore.isTransformDirty[i]) {
                    dirtyTransformIndices.add(i);
                    this.dataStore.isTransformDirty[i] = false;
                }
                if (!this.dataStore.isVertexDataDirty[i]) continue;
                dirtyVertexIndices.add(i);
                this.dataStore.isVertexDataDirty[i] = false;
            }
        }
        if (dirtyTransformIndices.isEmpty() && dirtyVertexIndices.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap transformUpdatesByPlayer = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap vertexUpdatesByPlayer = new Object2ObjectOpenHashMap();
        this.groupUpdatesByPlayer(dirtyTransformIndices, (Map<ServerPlayer, IntArrayList>)transformUpdatesByPlayer);
        this.groupUpdatesByPlayer(dirtyVertexIndices, (Map<ServerPlayer, IntArrayList>)vertexUpdatesByPlayer);
        if (!transformUpdatesByPlayer.isEmpty() || !vertexUpdatesByPlayer.isEmpty()) {
            this.level.getServer().execute(() -> this.lambda$sendStateUpdates$2((Map)transformUpdatesByPlayer, (Map)vertexUpdatesByPlayer));
        }
    }

    private void groupUpdatesByPlayer(IntArrayList dirtyIndices, Map<ServerPlayer, IntArrayList> updatesByPlayer) {
        IntListIterator intListIterator = dirtyIndices.iterator();
        while (intListIterator.hasNext()) {
            Set trackers;
            int dirtyIndex = (Integer)intListIterator.next();
            int networkId = this.dataStore.networkId[dirtyIndex];
            if (networkId == -1 || (trackers = (Set)this.bodyTrackers.get(networkId)) == null) continue;
            for (ServerPlayer player : trackers) {
                updatesByPlayer.computeIfAbsent(player, k -> new IntArrayList()).add(dirtyIndex);
            }
        }
    }

    private void sendBodyStatePackets(ServerPlayer player, IntArrayList indices) {
        if (indices.isEmpty()) {
            return;
        }
        int[] networkIds = new int[50];
        long[] timestamps = new long[50];
        double[] posX = new double[50];
        double[] posY = new double[50];
        double[] posZ = new double[50];
        float[] rotX = new float[50];
        float[] rotY = new float[50];
        float[] rotZ = new float[50];
        float[] rotW = new float[50];
        float[] velX = new float[50];
        float[] velY = new float[50];
        float[] velZ = new float[50];
        boolean[] isActive = new boolean[50];
        int currentBatchCount = 0;
        IntListIterator intListIterator = indices.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            int networkId = this.dataStore.networkId[index];
            if (networkId == -1) continue;
            networkIds[currentBatchCount] = networkId;
            timestamps[currentBatchCount] = this.dataStore.lastUpdateTimestamp[index];
            posX[currentBatchCount] = this.dataStore.posX[index];
            posY[currentBatchCount] = this.dataStore.posY[index];
            posZ[currentBatchCount] = this.dataStore.posZ[index];
            rotX[currentBatchCount] = this.dataStore.rotX[index];
            rotY[currentBatchCount] = this.dataStore.rotY[index];
            rotZ[currentBatchCount] = this.dataStore.rotZ[index];
            rotW[currentBatchCount] = this.dataStore.rotW[index];
            isActive[currentBatchCount] = this.dataStore.isActive[index];
            velX[currentBatchCount] = this.dataStore.velX[index];
            velY[currentBatchCount] = this.dataStore.velY[index];
            velZ[currentBatchCount] = this.dataStore.velZ[index];
            if (++currentBatchCount != 50) continue;
            S2CUpdateBodyStateBatchPacket packet = new S2CUpdateBodyStateBatchPacket(currentBatchCount, networkIds, timestamps, posX, posY, posZ, rotX, rotY, rotZ, rotW, velX, velY, velZ, isActive);
            VxPacketHandler.sendToPlayer(packet, player);
            currentBatchCount = 0;
        }
        if (currentBatchCount > 0) {
            S2CUpdateBodyStateBatchPacket packet = new S2CUpdateBodyStateBatchPacket(currentBatchCount, networkIds, timestamps, posX, posY, posZ, rotX, rotY, rotZ, rotW, velX, velY, velZ, isActive);
            VxPacketHandler.sendToPlayer(packet, player);
        }
    }

    private void sendVertexDataPackets(ServerPlayer player, IntArrayList indices) {
        if (indices.isEmpty()) {
            return;
        }
        for (int i = 0; i < indices.size(); i += 50) {
            int end = Math.min(i + 50, indices.size());
            IntList sublist = indices.subList(i, end);
            IntArrayList networkIdList = new IntArrayList();
            ObjectArrayList vertexList = new ObjectArrayList();
            Iterator iterator = sublist.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                int networkId = this.dataStore.networkId[index];
                if (networkId == -1) continue;
                networkIdList.add(networkId);
                vertexList.add((Object)this.dataStore.vertexData[index]);
            }
            if (networkIdList.isEmpty()) continue;
            S2CUpdateVerticesBatchPacket packet = new S2CUpdateVerticesBatchPacket(networkIdList.size(), networkIdList.toIntArray(), (float[][])vertexList.toArray((Object[])new float[0][]));
            VxPacketHandler.sendToPlayer(packet, player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSynchronizedDataUpdates() {
        IntArrayList dirtyDataIndices = new IntArrayList();
        VxBodyDataStore vxBodyDataStore = this.dataStore;
        synchronized (vxBodyDataStore) {
            for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
                if (!this.dataStore.isCustomDataDirty[i]) continue;
                dirtyDataIndices.add(i);
                this.dataStore.isCustomDataDirty[i] = false;
            }
        }
        if (dirtyDataIndices.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap updatesByPlayer = new Object2ObjectOpenHashMap();
        VxByteBuf buffer = THREAD_LOCAL_BYTE_BUF.get();
        IntListIterator intListIterator = dirtyDataIndices.iterator();
        while (intListIterator.hasNext()) {
            VxBody body;
            int dirtyIndex = (Integer)intListIterator.next();
            UUID bodyId = this.dataStore.getIdForIndex(dirtyIndex);
            if (bodyId == null || (body = this.manager.getVxBody(bodyId)) == null) continue;
            buffer.clear();
            if (!body.writeDirtySyncData(buffer)) continue;
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            Set trackers = (Set)this.bodyTrackers.get(body.getNetworkId());
            if (trackers == null) continue;
            for (ServerPlayer player : trackers) {
                updatesByPlayer.computeIfAbsent(player, k -> new Object2ObjectArrayMap()).put(body.getNetworkId(), data);
            }
        }
        if (!updatesByPlayer.isEmpty()) {
            this.level.getServer().execute(() -> VxNetworkDispatcher.lambda$sendSynchronizedDataUpdates$6((Map)updatesByPlayer));
        }
    }

    public void onBodyAdded(VxBody body) {
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        ChunkPos bodyChunk = this.manager.getBodyChunkPos(index);
        for (ServerPlayer player : this.level.getChunkSource().chunkMap.getPlayers(bodyChunk, false)) {
            this.trackBodyForPlayer(player, body);
        }
    }

    public void onBodyRemoved(VxBody body) {
        Set trackers = (Set)this.bodyTrackers.get(body.getNetworkId());
        if (trackers != null) {
            for (ServerPlayer player : new ArrayList(trackers)) {
                this.untrackBodyForPlayer(player, body.getNetworkId());
            }
        }
    }

    public void onBodyMoved(VxBody body, ChunkPos from, ChunkPos to) {
        if (from.equals((Object)to)) {
            return;
        }
        HashSet playersTrackingFrom = new HashSet(this.level.getChunkSource().chunkMap.getPlayers(from, false));
        HashSet playersTrackingTo = new HashSet(this.level.getChunkSource().chunkMap.getPlayers(to, false));
        for (ServerPlayer player : playersTrackingTo) {
            if (playersTrackingFrom.contains(player)) continue;
            this.trackBodyForPlayer(player, body);
        }
        for (ServerPlayer player : playersTrackingFrom) {
            if (playersTrackingTo.contains(player)) continue;
            this.untrackBodyForPlayer(player, body.getNetworkId());
        }
    }

    public void trackBodiesInChunkForPlayer(ServerPlayer player, ChunkPos chunkPos) {
        this.manager.getChunkManager().forEachBodyInChunk(chunkPos, body -> this.trackBodyForPlayer(player, (VxBody)body));
    }

    public void untrackBodiesInChunkForPlayer(ServerPlayer player, ChunkPos chunkPos) {
        this.manager.getChunkManager().forEachBodyInChunk(chunkPos, body -> this.untrackBodyForPlayer(player, body.getNetworkId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackBodyForPlayer(ServerPlayer player, VxBody body) {
        IntSet trackedByPlayer = this.playerTrackedBodies.computeIfAbsent(player.getUUID(), k -> IntSets.synchronize((IntSet)new IntOpenHashSet()));
        if (trackedByPlayer.add(body.getNetworkId())) {
            ((Set)this.bodyTrackers.computeIfAbsent(body.getNetworkId(), k -> ConcurrentHashMap.newKeySet())).add(player);
            Map<ServerPlayer, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
            synchronized (map) {
                IntArrayList removals = this.pendingRemovals.get(player);
                if (removals != null && removals.rem(body.getNetworkId())) {
                    return;
                }
                this.pendingSpawns.computeIfAbsent(player, k -> new ObjectArrayList()).add((Object)new VxSpawnData(body, System.nanoTime()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrackBodyForPlayer(ServerPlayer player, int networkId) {
        IntSet trackedByPlayer = this.playerTrackedBodies.get(player.getUUID());
        if (trackedByPlayer != null && trackedByPlayer.remove(networkId)) {
            Set trackers = (Set)this.bodyTrackers.get(networkId);
            if (trackers != null) {
                trackers.remove(player);
                if (trackers.isEmpty()) {
                    this.bodyTrackers.remove(networkId);
                }
            }
            Map<ServerPlayer, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
            synchronized (map) {
                ObjectArrayList<VxSpawnData> spawns = this.pendingSpawns.get(player);
                if (spawns != null && spawns.removeIf(spawnData -> spawnData.networkId == networkId)) {
                    return;
                }
                this.pendingRemovals.computeIfAbsent(player, k -> new IntArrayList()).add(networkId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlayerDisconnect(ServerPlayer player) {
        UUID playerId = player.getUUID();
        IntSet trackedBodies = this.playerTrackedBodies.remove(playerId);
        if (trackedBodies != null) {
            IntIterator iterator = trackedBodies.iterator();
            while (iterator.hasNext()) {
                int networkId = iterator.nextInt();
                Set trackers = (Set)this.bodyTrackers.get(networkId);
                if (trackers == null) continue;
                trackers.remove(player);
                if (!trackers.isEmpty()) continue;
                this.bodyTrackers.remove(networkId);
            }
        }
        Map<ServerPlayer, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
        synchronized (map) {
            this.pendingSpawns.remove(player);
            this.pendingRemovals.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingRemovals() {
        if (this.pendingRemovals.isEmpty()) {
            return;
        }
        Map<ServerPlayer, IntArrayList> map = this.pendingRemovals;
        synchronized (map) {
            this.pendingRemovals.forEach((player, removalList) -> {
                if (!removalList.isEmpty()) {
                    for (int i = 0; i < removalList.size(); i += 512) {
                        int end = Math.min(i + 512, removalList.size());
                        VxPacketHandler.sendToPlayer(new S2CRemoveBodyBatchPacket((List<Integer>)removalList.subList(i, end)), player);
                    }
                }
            });
            this.pendingRemovals.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingSpawns() {
        if (this.pendingSpawns.isEmpty()) {
            return;
        }
        Map<ServerPlayer, ObjectArrayList<VxSpawnData>> map = this.pendingSpawns;
        synchronized (map) {
            this.pendingSpawns.forEach((player, spawnDataList) -> {
                if (!spawnDataList.isEmpty()) {
                    ObjectArrayList batch = new ObjectArrayList();
                    int currentBatchSizeBytes = 0;
                    for (VxSpawnData data : spawnDataList) {
                        int dataSize = data.estimateSize();
                        if (!batch.isEmpty() && currentBatchSizeBytes + dataSize > 131072) {
                            VxPacketHandler.sendToPlayer(new S2CSpawnBodyBatchPacket((List<VxSpawnData>)batch), player);
                            batch.clear();
                            currentBatchSizeBytes = 0;
                        }
                        batch.add((Object)data);
                        currentBatchSizeBytes += dataSize;
                    }
                    if (!batch.isEmpty()) {
                        VxPacketHandler.sendToPlayer(new S2CSpawnBodyBatchPacket((List<VxSpawnData>)batch), player);
                    }
                }
            });
            this.pendingSpawns.clear();
        }
    }

    private static /* synthetic */ void lambda$sendSynchronizedDataUpdates$6(Map updatesByPlayer) {
        updatesByPlayer.forEach((player, dataMap) -> {
            if (!dataMap.isEmpty()) {
                VxPacketHandler.sendToPlayer(new S2CSynchronizedDataBatchPacket((Map<Integer, byte[]>)dataMap), player);
            }
        });
    }

    private /* synthetic */ void lambda$sendStateUpdates$2(Map transformUpdatesByPlayer, Map vertexUpdatesByPlayer) {
        transformUpdatesByPlayer.forEach(this::sendBodyStatePackets);
        vertexUpdatesByPlayer.forEach(this::sendVertexDataPackets);
    }
}

