/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.BodyLockMultiRead;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterfaceNoLock;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyMotionProperties;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.body.type.VxSoftBody;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxPhysicsUpdater {
    private final VxBodyManager manager;
    private final VxBodyDataStore dataStore;
    private final ThreadLocal<RVec3> tempPos = ThreadLocal.withInitial(RVec3::new);
    private final ThreadLocal<Quat> tempRot = ThreadLocal.withInitial(Quat::new);
    private final ThreadLocal<Vec3> tempLinVel = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<Vec3> tempAngVel = ThreadLocal.withInitial(Vec3::new);
    private final ThreadLocal<List<Integer>> bodyIdsToLock = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<List<Integer>> dataIndicesToLock = ThreadLocal.withInitial(ArrayList::new);

    public VxPhysicsUpdater(VxBodyManager manager) {
        this.manager = manager;
        this.dataStore = manager.getDataStore();
    }

    public void onPhysicsTick(VxPhysicsWorld world) {
        this.update(System.nanoTime(), world);
    }

    public void onGameTick(ServerLevel level) {
        this.manager.getAllBodies().forEach(obj -> obj.gameTick(level));
    }

    private void update(long timestampNanos, VxPhysicsWorld world) {
        BodyInterface bodyInterface = world.getPhysicsSystem().getBodyInterfaceNoLock();
        this.preUpdateSync(bodyInterface);
        this.postUpdateSync(timestampNanos, world, bodyInterface);
    }

    private void preUpdateSync(BodyInterface bodyInterface) {
        for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
            int bodyId;
            if (!this.dataStore.isGameStateDirty[i]) continue;
            UUID id = this.dataStore.getIdForIndex(i);
            if (id == null) {
                this.dataStore.isGameStateDirty[i] = false;
                continue;
            }
            VxBody body = this.manager.getVxBody(id);
            if (body != null && (bodyId = body.getBodyId()) != 0 && bodyInterface.isAdded(bodyId)) {
                RVec3 pos = this.tempPos.get();
                pos.set(this.dataStore.posX[i], this.dataStore.posY[i], this.dataStore.posZ[i]);
                Quat rot = this.tempRot.get();
                rot.set(this.dataStore.rotX[i], this.dataStore.rotY[i], this.dataStore.rotZ[i], this.dataStore.rotW[i]);
                bodyInterface.setPositionAndRotation(bodyId, pos, rot, EActivation.Activate);
                Vec3 linVel = this.tempLinVel.get();
                linVel.set(this.dataStore.velX[i], this.dataStore.velY[i], this.dataStore.velZ[i]);
                bodyInterface.setLinearVelocity(bodyId, linVel);
                Vec3 angVel = this.tempAngVel.get();
                angVel.set(this.dataStore.angVelX[i], this.dataStore.angVelY[i], this.dataStore.angVelZ[i]);
                bodyInterface.setAngularVelocity(bodyId, angVel);
            }
            this.dataStore.isGameStateDirty[i] = false;
        }
    }

    private void postUpdateSync(long timestampNanos, VxPhysicsWorld world, BodyInterface bodyInterface) {
        List<Integer> localBodyIdsToLock = this.bodyIdsToLock.get();
        List<Integer> localDataIndicesToLock = this.dataIndicesToLock.get();
        localBodyIdsToLock.clear();
        localDataIndicesToLock.clear();
        for (int i = 0; i < this.dataStore.getCapacity(); ++i) {
            int bodyId;
            VxBody obj;
            UUID id = this.dataStore.getIdForIndex(i);
            if (id == null || (obj = this.manager.getVxBody(id)) == null || (bodyId = obj.getBodyId()) == 0 || !bodyInterface.isAdded(bodyId)) continue;
            boolean isJoltBodyActive = bodyInterface.isActive(bodyId);
            boolean wasDataStoreBodyActive = this.dataStore.isActive[i];
            if (!isJoltBodyActive && !wasDataStoreBodyActive) continue;
            obj.physicsTick(world);
            RVec3 pos = this.tempPos.get();
            Quat rot = this.tempRot.get();
            bodyInterface.getPositionAndRotation(bodyId, pos, rot);
            this.dataStore.posX[i] = pos.x();
            this.dataStore.posY[i] = pos.y();
            this.dataStore.posZ[i] = pos.z();
            this.dataStore.rotX[i] = rot.getX();
            this.dataStore.rotY[i] = rot.getY();
            this.dataStore.rotZ[i] = rot.getZ();
            this.dataStore.rotW[i] = rot.getW();
            Vec3 linVel = this.tempLinVel.get();
            bodyInterface.getLinearVelocity(bodyId, linVel);
            this.dataStore.velX[i] = linVel.getX();
            this.dataStore.velY[i] = linVel.getY();
            this.dataStore.velZ[i] = linVel.getZ();
            Vec3 angVel = this.tempAngVel.get();
            bodyInterface.getAngularVelocity(bodyId, angVel);
            this.dataStore.angVelX[i] = angVel.getX();
            this.dataStore.angVelY[i] = angVel.getY();
            this.dataStore.angVelZ[i] = angVel.getZ();
            this.dataStore.motionType[i] = bodyInterface.getMotionType(bodyId);
            localBodyIdsToLock.add(bodyId);
            localDataIndicesToLock.add(i);
            this.dataStore.isActive[i] = isJoltBodyActive;
            this.dataStore.lastUpdateTimestamp[i] = timestampNanos;
            this.dataStore.isTransformDirty[i] = true;
            long lastKey = this.dataStore.chunkKey[i];
            long currentKey = new ChunkPos(SectionPos.posToSectionCoord((double)pos.x()), SectionPos.posToSectionCoord((double)pos.z())).toLong();
            if (lastKey == currentKey) continue;
            this.manager.getChunkManager().updateBodyTracking(obj, lastKey, currentKey);
            this.dataStore.chunkKey[i] = currentKey;
        }
        if (!localBodyIdsToLock.isEmpty()) {
            ConstBodyLockInterfaceNoLock lockInterface = world.getPhysicsSystem().getBodyLockInterfaceNoLock();
            int[] bodyIdArray = new int[localBodyIdsToLock.size()];
            for (int j = 0; j < localBodyIdsToLock.size(); ++j) {
                bodyIdArray[j] = localBodyIdsToLock.get(j);
            }
            try (BodyLockMultiRead multiLock = new BodyLockMultiRead(lockInterface, bodyIdArray);){
                for (int j = 0; j < bodyIdArray.length; ++j) {
                    VxBody obj;
                    int i;
                    UUID id;
                    ConstBody body = multiLock.getBody(j);
                    if (body == null || (id = this.dataStore.getIdForIndex(i = localDataIndicesToLock.get(j).intValue())) == null || (obj = this.manager.getVxBody(id)) == null) continue;
                    ConstAaBox bounds = body.getWorldSpaceBounds();
                    Vec3 min = bounds.getMin();
                    Vec3 max = bounds.getMax();
                    this.dataStore.aabbMinX[i] = min.getX();
                    this.dataStore.aabbMinY[i] = min.getY();
                    this.dataStore.aabbMinZ[i] = min.getZ();
                    this.dataStore.aabbMaxX[i] = max.getX();
                    this.dataStore.aabbMaxY[i] = max.getY();
                    this.dataStore.aabbMaxZ[i] = max.getZ();
                    if (!(obj instanceof VxSoftBody)) continue;
                    VxSoftBody softBody = (VxSoftBody)obj;
                    RVec3 pos = this.tempPos.get();
                    pos.set(this.dataStore.posX[i], this.dataStore.posY[i], this.dataStore.posZ[i]);
                    float[] newVertexData = this.getSoftBodyVertices(body, pos);
                    if (newVertexData == null || Arrays.equals(newVertexData, this.dataStore.vertexData[i])) continue;
                    this.dataStore.vertexData[i] = newVertexData;
                    this.dataStore.isVertexDataDirty[i] = true;
                    softBody.setLastSyncedVertexData(newVertexData);
                }
            }
        }
    }

    private float @Nullable [] getSoftBodyVertices(ConstBody body, RVec3Arg bodyPosition) {
        ConstSoftBodyMotionProperties motionProps;
        int numVertices;
        if (body.isSoftBody() && (numVertices = (motionProps = (ConstSoftBodyMotionProperties)body.getMotionProperties()).getSettings().countVertices()) > 0) {
            int bufferSize = numVertices * 3;
            FloatBuffer vertexBuffer = Jolt.newDirectFloatBuffer(bufferSize);
            motionProps.putVertexLocations(bodyPosition, vertexBuffer);
            vertexBuffer.flip();
            float[] vertexArray = new float[bufferSize];
            vertexBuffer.get(vertexArray);
            return vertexArray;
        }
        return null;
    }
}

