/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.manager.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.physics.body.manager.VxBodyDataStore;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.manager.VxNetworkDispatcher;
import net.xmx.velthoric.physics.body.type.VxBody;

public class VxChunkManager {
    private final VxBodyManager bodyManager;
    private final VxBodyDataStore dataStore;
    private final VxNetworkDispatcher networkDispatcher;
    private final Long2ObjectMap<List<VxBody>> bodiesByChunk = new Long2ObjectOpenHashMap();

    public VxChunkManager(VxBodyManager bodyManager) {
        this.bodyManager = bodyManager;
        this.dataStore = bodyManager.getDataStore();
        this.networkDispatcher = bodyManager.getNetworkDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking(VxBody body) {
        long key;
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        this.dataStore.chunkKey[index] = key = this.bodyManager.getBodyChunkPos(index).toLong();
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            ((List)this.bodiesByChunk.computeIfAbsent(key, k -> new ArrayList())).add(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking(VxBody body) {
        int index = body.getDataStoreIndex();
        if (index == -1) {
            return;
        }
        long key = this.dataStore.chunkKey[index];
        if (key != Long.MAX_VALUE) {
            Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
            synchronized (long2ObjectMap) {
                List list = (List)this.bodiesByChunk.get(key);
                if (list != null) {
                    list.remove(body);
                    if (list.isEmpty()) {
                        this.bodiesByChunk.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBodyTracking(VxBody body, long fromKey, long toKey) {
        int index = body.getDataStoreIndex();
        if (index != -1) {
            this.dataStore.chunkKey[index] = toKey;
        }
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            List fromList;
            if (fromKey != Long.MAX_VALUE && (fromList = (List)this.bodiesByChunk.get(fromKey)) != null) {
                fromList.remove(body);
                if (fromList.isEmpty()) {
                    this.bodiesByChunk.remove(fromKey);
                }
            }
            ((List)this.bodiesByChunk.computeIfAbsent(toKey, k -> new ArrayList())).add(body);
        }
        this.networkDispatcher.onBodyMoved(body, new ChunkPos(fromKey), new ChunkPos(toKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachBodyInChunk(ChunkPos pos, Consumer<VxBody> action) {
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            List bodies = (List)this.bodiesByChunk.get(pos.toLong());
            if (bodies != null && !bodies.isEmpty()) {
                for (VxBody body : bodies) {
                    action.accept(body);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VxBody> removeAllInChunk(ChunkPos pos) {
        Long2ObjectMap<List<VxBody>> long2ObjectMap = this.bodiesByChunk;
        synchronized (long2ObjectMap) {
            List<VxBody> removed = (List<VxBody>)this.bodiesByChunk.remove(pos.toLong());
            return removed != null ? removed : Collections.emptyList();
        }
    }
}

