/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.type.VxBody;

public class VxSpawnData {
    public final UUID id;
    public final int networkId;
    public final ResourceLocation typeIdentifier;
    public final long timestamp;
    public final byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VxSpawnData(VxBody obj, long timestamp) {
        this.id = obj.getPhysicsId();
        this.networkId = obj.getNetworkId();
        this.typeIdentifier = obj.getType().getTypeId();
        this.timestamp = timestamp;
        VxByteBuf buf = new VxByteBuf(Unpooled.buffer());
        try {
            obj.getTransform().toBuffer(buf);
            obj.writeInitialSyncData(buf);
            this.data = new byte[buf.readableBytes()];
            buf.readBytes(this.data);
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    public VxSpawnData(FriendlyByteBuf buf) {
        this.id = buf.readUUID();
        this.networkId = buf.readVarInt();
        this.typeIdentifier = buf.readResourceLocation();
        this.timestamp = buf.readLong();
        this.data = buf.readByteArray();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.id);
        buf.writeVarInt(this.networkId);
        buf.writeResourceLocation(this.typeIdentifier);
        buf.writeLong(this.timestamp);
        buf.writeByteArray(this.data);
    }

    public int estimateSize() {
        String typeStr = this.typeIdentifier.toString();
        return 16 + VxByteBuf.varIntSize(this.networkId) + VxByteBuf.varIntSize(typeStr.length()) + typeStr.length() + 8 + VxByteBuf.varIntSize(this.data.length) + this.data.length;
    }
}

