/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;

public class S2CRemoveBodyBatchPacket {
    private final List<Integer> networkIds;

    public S2CRemoveBodyBatchPacket(List<Integer> networkIds) {
        this.networkIds = networkIds;
    }

    public static void encode(S2CRemoveBodyBatchPacket msg, FriendlyByteBuf buf) {
        FriendlyByteBuf tempBuf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            tempBuf.writeVarInt(msg.networkIds.size());
            for (Integer id : msg.networkIds) {
                tempBuf.writeVarInt(id.intValue());
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.writeVarInt(uncompressedData.length);
            buf.writeByteArray(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress remove body batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CRemoveBodyBatchPacket decode(FriendlyByteBuf buf) {
        int uncompressedSize = buf.readVarInt();
        byte[] compressedData = buf.readByteArray();
        try {
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            FriendlyByteBuf decompressedBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.readVarInt();
            IntArrayList ids = new IntArrayList(size);
            for (int i = 0; i < size; ++i) {
                ids.add(decompressedBuf.readVarInt());
            }
            return new S2CRemoveBodyBatchPacket((List<Integer>)ids);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress remove body batch packet", e);
        }
    }

    public static void handle(S2CRemoveBodyBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (int networkId : msg.networkIds) {
                manager.removeBody(networkId);
            }
        });
    }
}

