/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;

public class S2CSynchronizedDataBatchPacket {
    private final Map<Integer, byte[]> dataUpdates;

    public S2CSynchronizedDataBatchPacket(Map<Integer, byte[]> dataUpdates) {
        this.dataUpdates = dataUpdates;
    }

    public static void encode(S2CSynchronizedDataBatchPacket msg, FriendlyByteBuf buf) {
        FriendlyByteBuf tempBuf = new FriendlyByteBuf(Unpooled.buffer());
        try {
            tempBuf.writeVarInt(msg.dataUpdates.size());
            for (Map.Entry<Integer, byte[]> entry : msg.dataUpdates.entrySet()) {
                tempBuf.writeVarInt(entry.getKey().intValue());
                tempBuf.writeByteArray(entry.getValue());
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.writeVarInt(uncompressedData.length);
            buf.writeByteArray(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress sync data batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CSynchronizedDataBatchPacket decode(FriendlyByteBuf buf) {
        try {
            int uncompressedSize = buf.readVarInt();
            byte[] compressedData = buf.readByteArray();
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            FriendlyByteBuf decompressedBuf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.readVarInt();
            Int2ObjectArrayMap dataUpdates = new Int2ObjectArrayMap(size);
            for (int i = 0; i < size; ++i) {
                int id = decompressedBuf.readVarInt();
                byte[] data = decompressedBuf.readByteArray();
                dataUpdates.put(id, data);
            }
            return new S2CSynchronizedDataBatchPacket((Map<Integer, byte[]>)dataUpdates);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress sync data batch packet", e);
        }
    }

    public static void handle(S2CSynchronizedDataBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (Map.Entry<Integer, byte[]> entry : msg.dataUpdates.entrySet()) {
                manager.updateSynchronizedData(entry.getKey(), Unpooled.wrappedBuffer((byte[])entry.getValue()));
            }
        });
    }
}

