/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.util;

import com.github.stephengold.joltjni.AllHitCollideShapeBodyCollector;
import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockWrite;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SoftBodyMotionProperties;
import com.github.stephengold.joltjni.SoftBodyVertex;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseQuery;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxExplosionUtil {
    public void applyExplosion(VxPhysicsWorld physicsWorld, Vec3 explosionCenter, float explosionRadius, float explosionStrength) {
        if (!physicsWorld.isRunning()) {
            return;
        }
        physicsWorld.execute(() -> {
            PhysicsSystem physicsSystem = physicsWorld.getPhysicsSystem();
            if (physicsSystem == null) {
                return;
            }
            ConstBroadPhaseQuery broadPhaseQuery = physicsSystem.getBroadPhaseQuery();
            AllHitCollideShapeBodyCollector collector = new AllHitCollideShapeBodyCollector();
            BroadPhaseLayerFilter broadPhaseFilter = new BroadPhaseLayerFilter();
            ObjectLayerFilter objectFilter = new ObjectLayerFilter();
            try {
                int[] hitBodyIds;
                broadPhaseQuery.collideSphere(explosionCenter, explosionRadius, collector, broadPhaseFilter, objectFilter);
                for (int bodyId : hitBodyIds = collector.getHits()) {
                    physicsSystem.getBodyInterface().activateBody(bodyId);
                    try (BodyLockWrite lock = new BodyLockWrite(physicsSystem.getBodyLockInterface(), bodyId);){
                        SoftBodyMotionProperties motionProperties;
                        SoftBodyVertex[] vertices;
                        Body body;
                        if (!lock.succeededAndIsInBroadPhase() || (body = lock.getBody()).isStatic()) continue;
                        if (body.isRigidBody()) {
                            RVec3 bodyPosR = body.getCenterOfMassPosition();
                            Vec3 vectorToBody = Op.minus((RVec3Arg)bodyPosR, explosionCenter.toRVec3()).toVec3();
                            float distanceSq = vectorToBody.lengthSq();
                            if (!(distanceSq < explosionRadius * explosionRadius) || !(distanceSq > 1.0E-6f)) continue;
                            float distance = (float)Math.sqrt(distanceSq);
                            float falloff = 1.0f - distance / explosionRadius;
                            float impulseMagnitude = explosionStrength * falloff * falloff;
                            Vec3 impulseDirection = vectorToBody.normalized();
                            Vec3 impulse = Op.star((Vec3Arg)impulseDirection, impulseMagnitude);
                            body.addImpulse(impulse);
                            continue;
                        }
                        if (!body.isSoftBody() || (vertices = (motionProperties = (SoftBodyMotionProperties)body.getMotionProperties()).getVertices()).length == 0) continue;
                        for (SoftBodyVertex vertex : vertices) {
                            Vec3 vertexPos = vertex.getPosition();
                            Vec3 vectorToVertex = Op.minus(vertexPos, (Vec3Arg)explosionCenter);
                            float distanceSq = vectorToVertex.lengthSq();
                            if (!(distanceSq < explosionRadius * explosionRadius) || !(distanceSq > 1.0E-6f)) continue;
                            float distance = (float)Math.sqrt(distanceSq);
                            float falloff = 1.0f - distance / explosionRadius;
                            float impulseMagnitude = explosionStrength / (float)vertices.length * falloff * falloff;
                            Vec3 impulseDirection = vectorToVertex.normalized();
                            Vec3 impulse = Op.star((Vec3Arg)impulseDirection, impulseMagnitude);
                            if (!(vertex.getInvMass() > 0.0f)) continue;
                            Vec3 deltaV = Op.star((Vec3Arg)impulse, vertex.getInvMass());
                            vertex.setVelocity(Op.plus((Vec3Arg)vertex.getVelocity(), (Vec3Arg)deltaV));
                        }
                    }
                }
            }
            finally {
                collector.close();
                broadPhaseFilter.close();
                objectFilter.close();
            }
        });
    }
}

