/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.util;

import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.xmx.velthoric.init.VxMainClass;

public final class VxVoxelShapeUtil {
    private VxVoxelShapeUtil() {
    }

    public static MutableCompoundShapeSettings toMutableCompoundShape(VoxelShape voxelShape) {
        if (voxelShape == null || voxelShape.isEmpty()) {
            return null;
        }
        List aabbs = voxelShape.toAabbs();
        if (aabbs.isEmpty()) {
            return null;
        }
        MutableCompoundShapeSettings compoundShape = new MutableCompoundShapeSettings();
        Quat identityRotation = Quat.sIdentity();
        try {
            for (AABB aabb : aabbs) {
                float hx = (float)(aabb.maxX - aabb.minX) / 2.0f;
                float hy = (float)(aabb.maxY - aabb.minY) / 2.0f;
                float hz = (float)(aabb.maxZ - aabb.minZ) / 2.0f;
                float cx = (float)(aabb.minX + (double)hx - 0.5);
                float cy = (float)(aabb.minY + (double)hy - 0.5);
                float cz = (float)(aabb.minZ + (double)hz - 0.5);
                Vec3 position = new Vec3(cx, cy, cz);
                Vec3 halfExtents = new Vec3(hx, hy, hz);
                try (BoxShapeSettings boxSettings = new BoxShapeSettings(halfExtents, 0.0f);){
                    compoundShape.addShape((Vec3Arg)position, (QuatArg)identityRotation, boxSettings);
                }
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error converting VoxelShape to Jolt compound shape", (Throwable)e);
            compoundShape.close();
            return null;
        }
        return compoundShape;
    }
}

