/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy;

import com.github.stephengold.joltjni.BodyLockMultiWrite;
import java.util.Arrays;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyDataStore;
import net.xmx.velthoric.physics.buoyancy.phase.VxBuoyancyBroadPhase;
import net.xmx.velthoric.physics.buoyancy.phase.VxBuoyancyNarrowPhase;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxBuoyancyManager {
    private final VxPhysicsWorld physicsWorld;
    private final VxBuoyancyBroadPhase broadPhase;
    private final VxBuoyancyNarrowPhase narrowPhase;
    private VxBuoyancyDataStore writeBuffer;
    private volatile VxBuoyancyDataStore readBuffer;

    public VxBuoyancyManager(VxPhysicsWorld physicsWorld) {
        this.physicsWorld = physicsWorld;
        this.broadPhase = new VxBuoyancyBroadPhase(physicsWorld);
        this.narrowPhase = new VxBuoyancyNarrowPhase(physicsWorld);
        this.writeBuffer = new VxBuoyancyDataStore();
        this.readBuffer = new VxBuoyancyDataStore();
    }

    public void updateFluidStates() {
        this.writeBuffer.clear();
        this.broadPhase.findPotentialFluidContacts(this.writeBuffer);
        VxBuoyancyDataStore oldReadBuffer = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = oldReadBuffer;
    }

    public void applyBuoyancyForces(float deltaTime) {
        VxBuoyancyDataStore currentReadBuffer = this.readBuffer;
        int bodyCount = currentReadBuffer.getCount();
        if (bodyCount == 0) {
            return;
        }
        int[] bodyIds = Arrays.copyOf(currentReadBuffer.bodyIds, bodyCount);
        try (BodyLockMultiWrite lock = new BodyLockMultiWrite(this.physicsWorld.getPhysicsSystem().getBodyLockInterfaceNoLock(), bodyIds);){
            this.narrowPhase.applyForces(lock, deltaTime, currentReadBuffer);
        }
    }

    public void shutdown() {
        this.writeBuffer.clear();
        this.readBuffer.clear();
    }
}

