/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.buoyancy.phase;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockMultiWrite;
import com.github.stephengold.joltjni.CompoundShape;
import com.github.stephengold.joltjni.DecoratedShape;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.OffsetCenterOfMassShape;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.RotatedTranslatedShape;
import com.github.stephengold.joltjni.ScaledShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeType;
import com.github.stephengold.joltjni.readonly.ConstConvexShape;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstSubShape;
import net.xmx.velthoric.physics.buoyancy.VxBuoyancyDataStore;
import net.xmx.velthoric.physics.buoyancy.floater.VxBuoyancyAABBFloater;
import net.xmx.velthoric.physics.buoyancy.floater.VxBuoyancyConvexFloater;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxBuoyancyNarrowPhase {
    private final VxPhysicsWorld physicsWorld;
    private final VxBuoyancyAABBFloater aabbFloater;
    private final VxBuoyancyConvexFloater convexFloater;
    private final ThreadLocal<RMat44> tempRMat44 = ThreadLocal.withInitial(RMat44::new);
    private final ThreadLocal<RVec3> tempRVec3 = ThreadLocal.withInitial(RVec3::new);
    private final ThreadLocal<Mat44> tempMat44 = ThreadLocal.withInitial(Mat44::new);
    private final ThreadLocal<Vec3> tempScaleVec = ThreadLocal.withInitial(() -> new Vec3(1.0f, 1.0f, 1.0f));

    public VxBuoyancyNarrowPhase(VxPhysicsWorld physicsWorld) {
        this.physicsWorld = physicsWorld;
        this.aabbFloater = new VxBuoyancyAABBFloater(physicsWorld);
        this.convexFloater = new VxBuoyancyConvexFloater(physicsWorld);
    }

    public void applyForces(BodyLockMultiWrite lock, float deltaTime, VxBuoyancyDataStore dataStore) {
        for (int i = 0; i < dataStore.getCount(); ++i) {
            Body body = lock.getBody(i);
            if (body == null) continue;
            this.processBuoyancyForBody(body, deltaTime, i, dataStore);
        }
    }

    private void processBuoyancyForBody(Body body, float deltaTime, int index, VxBuoyancyDataStore dataStore) {
        if (!body.isActive()) {
            return;
        }
        MotionProperties motionProperties = body.getMotionProperties();
        if (motionProperties == null || motionProperties.getInverseMass() < 1.0E-6f) {
            return;
        }
        ConstShape shape = body.getShape();
        if (shape == null) {
            return;
        }
        if (this.isShapeHierarchySupported(shape)) {
            RVec3 bodyCom = this.tempRVec3.get();
            body.getCenterOfMassPosition(bodyCom);
            this.processShapeRecursively(body, shape, body.getCenterOfMassTransform(), bodyCom, deltaTime, index, dataStore);
        } else {
            this.aabbFloater.applyForces(body, deltaTime, index, dataStore);
        }
    }

    private boolean isShapeHierarchySupported(ConstShape shape) {
        if (shape instanceof ScaledShape) {
            return false;
        }
        if (shape instanceof DecoratedShape) {
            DecoratedShape decorated = (DecoratedShape)shape;
            return this.isShapeHierarchySupported(decorated.getInnerShape());
        }
        if (shape.getType() == EShapeType.Compound) {
            CompoundShape compound = (CompoundShape)shape;
            for (int i = 0; i < compound.getNumSubShapes(); ++i) {
                if (this.isShapeHierarchySupported(compound.getSubShape(i).getShape())) continue;
                return false;
            }
        } else if (shape.getType() != EShapeType.Convex) {
            return false;
        }
        return true;
    }

    private void processShapeRecursively(Body body, ConstShape shape, RMat44 currentTransform, RVec3 bodyCom, float deltaTime, int index, VxBuoyancyDataStore dataStore) {
        if (shape instanceof DecoratedShape) {
            DecoratedShape decoratedShape = (DecoratedShape)shape;
            ConstShape innerShape = decoratedShape.getInnerShape();
            RMat44 newTransform = this.tempRMat44.get();
            if (decoratedShape instanceof RotatedTranslatedShape) {
                RotatedTranslatedShape rtShape = (RotatedTranslatedShape)decoratedShape;
                this.tempMat44.get();
                Mat44 localTransform = Mat44.sRotationTranslation(rtShape.getRotation(), rtShape.getPosition());
                newTransform.set(currentTransform.multiply(localTransform));
                this.processShapeRecursively(body, innerShape, newTransform, bodyCom, deltaTime, index, dataStore);
            } else if (decoratedShape instanceof OffsetCenterOfMassShape) {
                OffsetCenterOfMassShape ocomShape = (OffsetCenterOfMassShape)decoratedShape;
                this.tempMat44.get();
                Mat44 localTransform = Mat44.sTranslation(ocomShape.getOffset());
                newTransform.set(currentTransform.multiply(localTransform));
                this.processShapeRecursively(body, innerShape, newTransform, bodyCom, deltaTime, index, dataStore);
            }
            return;
        }
        if (shape.getType() == EShapeType.Compound) {
            CompoundShape compound = (CompoundShape)shape;
            for (int i = 0; i < compound.getNumSubShapes(); ++i) {
                ConstSubShape subShape = compound.getSubShape(i);
                Vec3 scale = this.tempScaleVec.get();
                Mat44 localTransform = subShape.getLocalTransformNoScale(scale);
                RMat44 subShapeWorldTransform = this.tempRMat44.get();
                subShapeWorldTransform.set(currentTransform.multiply(localTransform));
                this.processShapeRecursively(body, subShape.getShape(), subShapeWorldTransform, bodyCom, deltaTime, index, dataStore);
            }
            return;
        }
        if (shape.getType() == EShapeType.Convex) {
            this.convexFloater.applyBuoyancyToConvexPart(body, (ConstConvexShape)shape, currentTransform, bodyCom, deltaTime, index, dataStore);
        }
    }
}

