/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.manager;

import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.ConeConstraintSettings;
import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.DistanceConstraintSettings;
import com.github.stephengold.joltjni.FixedConstraintSettings;
import com.github.stephengold.joltjni.HingeConstraintSettings;
import com.github.stephengold.joltjni.ObjectStreamIn;
import com.github.stephengold.joltjni.PointConstraintSettings;
import com.github.stephengold.joltjni.SixDofConstraintSettings;
import com.github.stephengold.joltjni.SliderConstraintSettings;
import com.github.stephengold.joltjni.SwingTwistConstraintSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.TwoBodyConstraintSettingsRef;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.std.StringStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.body.manager.VxBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.constraint.VxConstraint;
import net.xmx.velthoric.physics.constraint.manager.VxDependencyDataSystem;
import net.xmx.velthoric.physics.constraint.persistence.VxConstraintStorage;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.jetbrains.annotations.Nullable;

public class VxConstraintManager {
    public static final UUID WORLD_BODY_ID = new UUID(0L, 0L);
    private final VxPhysicsWorld world;
    private final VxBodyManager bodyManager;
    private final VxConstraintStorage constraintStorage;
    private final VxDependencyDataSystem dataSystem;
    private final Map<UUID, VxConstraint> activeConstraints = new ConcurrentHashMap<UUID, VxConstraint>();

    public VxConstraintManager(VxBodyManager bodyManager) {
        this.bodyManager = bodyManager;
        this.world = bodyManager.getPhysicsWorld();
        this.constraintStorage = new VxConstraintStorage(this.world.getLevel(), this);
        this.dataSystem = new VxDependencyDataSystem(this);
    }

    public void initialize() {
        this.constraintStorage.initialize();
    }

    public void shutdown() {
        VxMainClass.LOGGER.debug("Flushing physics constraint persistence for world {}...", (Object)this.world.getDimensionKey().location());
        this.flushPersistence(true);
        VxMainClass.LOGGER.debug("Physics constraint persistence flushed for world {}.", (Object)this.world.getDimensionKey().location());
        this.activeConstraints.clear();
        this.dataSystem.clear();
        this.constraintStorage.shutdown();
    }

    public void saveConstraintsInChunk(ChunkPos pos) {
        ArrayList<VxConstraint> constraintsToSave = new ArrayList<VxConstraint>();
        for (VxConstraint constraint : this.activeConstraints.values()) {
            if (!this.isConstraintInChunk(constraint, pos)) continue;
            constraintsToSave.add(constraint);
        }
        if (!constraintsToSave.isEmpty()) {
            this.processAndStoreConstraints(constraintsToSave);
        }
    }

    public void flushPersistence(boolean block) {
        try {
            CompletableFuture<Void> future = this.constraintStorage.saveDirtyRegions();
            this.constraintStorage.getRegionIndex().save();
            if (block) {
                future.join();
            }
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Failed to flush physics constraint persistence for world {}", (Object)this.world.getLevel().dimension().location(), (Object)e);
        }
    }

    public void onChunkUnload(ChunkPos pos) {
        ArrayList<VxConstraint> constraintsToUnload = new ArrayList<VxConstraint>();
        for (VxConstraint constraint : this.activeConstraints.values()) {
            if (!this.isConstraintInChunk(constraint, pos)) continue;
            constraintsToUnload.add(constraint);
        }
        if (constraintsToUnload.isEmpty()) {
            return;
        }
        this.processAndStoreConstraints(constraintsToUnload);
        for (VxConstraint constraint : constraintsToUnload) {
            this.removeConstraint(constraint.getConstraintId(), false);
        }
    }

    @Nullable
    public VxConstraint createConstraint(TwoBodyConstraintSettings settings, UUID body1Id, UUID body2Id) {
        if (settings == null || body1Id == null || body2Id == null) {
            return null;
        }
        UUID constraintId = UUID.randomUUID();
        VxConstraint constraint = new VxConstraint(constraintId, body1Id, body2Id, settings);
        this.dataSystem.addPendingConstraint(constraint);
        return constraint;
    }

    public void addConstraintFromStorage(VxConstraint constraint) {
        this.dataSystem.addPendingConstraint(constraint);
    }

    protected void activateConstraint(VxConstraint constraint) {
        this.world.execute(() -> {
            boolean isBody1World = constraint.getBody1Id().equals(WORLD_BODY_ID);
            boolean isBody2World = constraint.getBody2Id().equals(WORLD_BODY_ID);
            try (TwoBodyConstraintSettings loadedSettings = this.deserializeSettings(constraint);){
                TwoBodyConstraint joltConstraint;
                if (loadedSettings == null) {
                    VxMainClass.LOGGER.error("Failed to deserialize settings for constraint {}", (Object)constraint.getConstraintId());
                    return;
                }
                BodyInterface bodyInterface = this.world.getPhysicsSystem().getBodyInterface();
                int worldBodyJoltId = -1;
                if (isBody1World || isBody2World) {
                    if (isBody1World && isBody2World) {
                        return;
                    }
                    UUID realBodyUuid = isBody1World ? constraint.getBody2Id() : constraint.getBody1Id();
                    VxBody realBody = this.bodyManager.getVxBody(realBodyUuid);
                    if (realBody == null || realBody.getBodyId() == 0) {
                        this.dataSystem.addPendingConstraint(constraint);
                        return;
                    }
                    joltConstraint = isBody1World ? bodyInterface.createConstraint(loadedSettings, -1, realBody.getBodyId()) : bodyInterface.createConstraint(loadedSettings, realBody.getBodyId(), -1);
                } else {
                    VxBody body1 = this.bodyManager.getVxBody(constraint.getBody1Id());
                    VxBody body2 = this.bodyManager.getVxBody(constraint.getBody2Id());
                    if (body1 == null || body2 == null || body1.getBodyId() == 0 || body2.getBodyId() == 0) {
                        this.dataSystem.addPendingConstraint(constraint);
                        return;
                    }
                    joltConstraint = bodyInterface.createConstraint(loadedSettings, body1.getBodyId(), body2.getBodyId());
                }
                this.finishActivation(constraint, joltConstraint, loadedSettings);
            }
            catch (Exception e) {
                VxMainClass.LOGGER.error("Exception during constraint activation for {}", (Object)constraint.getConstraintId(), (Object)e);
            }
        });
    }

    private void finishActivation(VxConstraint constraint, TwoBodyConstraint joltConstraint, TwoBodyConstraintSettings settings) {
        boolean wasCreatedWithWorldSpace;
        if (joltConstraint == null) {
            VxMainClass.LOGGER.error("Failed to create Jolt constraint for {}", (Object)constraint.getConstraintId());
            return;
        }
        boolean bl = wasCreatedWithWorldSpace = this.getConstraintSpace(settings) == EConstraintSpace.WorldSpace;
        if (wasCreatedWithWorldSpace) {
            try (ConstraintSettingsRef settingsRef = joltConstraint.getConstraintSettings();
                 ConstraintSettings canonicalSettingsRaw = settingsRef.getPtr();){
                if (canonicalSettingsRaw instanceof TwoBodyConstraintSettings) {
                    TwoBodyConstraintSettings canonicalSettings = (TwoBodyConstraintSettings)canonicalSettingsRaw;
                    constraint.updateSettingsData(canonicalSettings);
                }
            }
        }
        this.world.getPhysicsSystem().addConstraint(joltConstraint);
        constraint.setJoltConstraint(joltConstraint);
        this.activeConstraints.put(constraint.getConstraintId(), constraint);
    }

    @Nullable
    private TwoBodyConstraintSettings deserializeSettings(VxConstraint constraint) {
        String settingsString = new String(constraint.getSettingsData(), StandardCharsets.ISO_8859_1);
        try (StringStream stringStream = new StringStream(settingsString);){
            TwoBodyConstraintSettingsRef settingsRef;
            block12: {
                TwoBodyConstraintSettings twoBodyConstraintSettings;
                settingsRef = new TwoBodyConstraintSettingsRef();
                try {
                    if (!ObjectStreamIn.sReadObject(stringStream, settingsRef)) break block12;
                    twoBodyConstraintSettings = settingsRef.getPtr();
                }
                catch (Throwable throwable) {
                    try {
                        settingsRef.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                settingsRef.close();
                return twoBodyConstraintSettings;
            }
            TwoBodyConstraintSettings twoBodyConstraintSettings = null;
            settingsRef.close();
            return twoBodyConstraintSettings;
        }
    }

    private EConstraintSpace getConstraintSpace(TwoBodyConstraintSettings settings) {
        if (settings instanceof PointConstraintSettings) {
            PointConstraintSettings s = (PointConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof HingeConstraintSettings) {
            HingeConstraintSettings s = (HingeConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof ConeConstraintSettings) {
            ConeConstraintSettings s = (ConeConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof DistanceConstraintSettings) {
            DistanceConstraintSettings s = (DistanceConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof FixedConstraintSettings) {
            FixedConstraintSettings s = (FixedConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof SixDofConstraintSettings) {
            SixDofConstraintSettings s = (SixDofConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof SliderConstraintSettings) {
            SliderConstraintSettings s = (SliderConstraintSettings)settings;
            return s.getSpace();
        }
        if (settings instanceof SwingTwistConstraintSettings) {
            SwingTwistConstraintSettings s = (SwingTwistConstraintSettings)settings;
            return s.getSpace();
        }
        return EConstraintSpace.LocalToBodyCom;
    }

    public void removeConstraint(UUID constraintId, boolean discardData) {
        VxConstraint constraint = this.activeConstraints.remove(constraintId);
        if (constraint != null && constraint.getJoltConstraint() != null) {
            this.world.execute(() -> {
                this.world.getPhysicsSystem().removeConstraint(constraint.getJoltConstraint());
                constraint.getJoltConstraint().close();
            });
        }
        if (discardData) {
            this.constraintStorage.removeData(constraintId);
        }
    }

    public void removeConstraintsForBody(UUID bodyId, boolean discardData) {
        this.activeConstraints.values().stream().filter(c -> c.getBody1Id().equals(bodyId) || c.getBody2Id().equals(bodyId)).forEach(c -> this.removeConstraint(c.getConstraintId(), discardData));
        this.dataSystem.removeForBody(bodyId);
    }

    public boolean hasActiveConstraint(UUID id) {
        return this.activeConstraints.containsKey(id);
    }

    public VxConstraintStorage getConstraintStorage() {
        return this.constraintStorage;
    }

    public VxBodyManager getBodyManager() {
        return this.bodyManager;
    }

    public VxDependencyDataSystem getDataSystem() {
        return this.dataSystem;
    }

    private boolean isConstraintInChunk(VxConstraint constraint, ChunkPos pos) {
        UUID bodyId;
        UUID uUID = bodyId = !constraint.getBody1Id().equals(WORLD_BODY_ID) ? constraint.getBody1Id() : constraint.getBody2Id();
        if (bodyId.equals(WORLD_BODY_ID)) {
            return false;
        }
        VxBody body = this.bodyManager.getVxBody(bodyId);
        if (body != null) {
            int index = body.getDataStoreIndex();
            return index != -1 && this.bodyManager.getDataStore().chunkKey[index] == pos.toLong();
        }
        return false;
    }

    private void processAndStoreConstraints(List<VxConstraint> constraints) {
        this.world.execute(() -> {
            HashMap<VxAbstractRegionStorage.RegionPos, Map<UUID, byte[]>> dataByRegion = new HashMap<VxAbstractRegionStorage.RegionPos, Map<UUID, byte[]>>();
            for (VxConstraint constraint : constraints) {
                ChunkPos chunkPos;
                byte[] snapshot;
                VxBody chunkBody;
                UUID chunkBodyId = !constraint.getBody1Id().equals(WORLD_BODY_ID) ? constraint.getBody1Id() : constraint.getBody2Id();
                if (chunkBodyId.equals(WORLD_BODY_ID) || (chunkBody = this.bodyManager.getVxBody(chunkBodyId)) == null || chunkBody.getDataStoreIndex() == -1 || (snapshot = this.constraintStorage.serializeConstraintData(constraint, chunkPos = this.bodyManager.getBodyChunkPos(chunkBody.getDataStoreIndex()))) == null) continue;
                VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.x >> 5, chunkPos.z >> 5);
                dataByRegion.computeIfAbsent(regionPos, k -> new HashMap()).put(constraint.getConstraintId(), snapshot);
            }
            if (!dataByRegion.isEmpty()) {
                this.constraintStorage.storeConstraintBatch(dataByRegion);
            }
        });
    }
}

