/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.persistence;

import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.physics.constraint.VxConstraint;

public final class VxConstraintCodec {
    private VxConstraintCodec() {
    }

    public static void serialize(VxConstraint constraint, FriendlyByteBuf buf) {
        buf.writeUUID(constraint.getBody1Id());
        buf.writeUUID(constraint.getBody2Id());
        buf.writeInt(constraint.getSubType().ordinal());
        buf.writeByteArray(constraint.getSettingsData());
    }

    public static VxConstraint deserialize(UUID constraintId, FriendlyByteBuf buf) {
        UUID body1Id = buf.readUUID();
        UUID body2Id = buf.readUUID();
        EConstraintSubType subType = EConstraintSubType.values()[buf.readInt()];
        byte[] settingsData = buf.readByteArray();
        return new VxConstraint(constraintId, body1Id, body2Id, settingsData, subType);
    }
}

