/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.constraint.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.physics.constraint.VxConstraint;
import net.xmx.velthoric.physics.constraint.manager.VxConstraintManager;
import net.xmx.velthoric.physics.constraint.persistence.VxConstraintCodec;
import net.xmx.velthoric.physics.persistence.VxAbstractRegionStorage;
import net.xmx.velthoric.physics.persistence.VxRegionIndex;
import org.jetbrains.annotations.Nullable;

public class VxConstraintStorage
extends VxAbstractRegionStorage<UUID, byte[]> {
    private final VxConstraintManager constraintManager;
    private final ConcurrentMap<Long, List<UUID>> chunkToUuidIndex = new ConcurrentHashMap<Long, List<UUID>>();

    public VxConstraintStorage(ServerLevel level, VxConstraintManager constraintManager) {
        super(level, "constraint", "constraint");
        this.constraintManager = constraintManager;
    }

    @Override
    protected VxRegionIndex createRegionIndex() {
        return new VxRegionIndex(this.storagePath, "constraint");
    }

    @Override
    protected void readRegionData(ByteBuf buffer, VxAbstractRegionStorage.RegionData<UUID, byte[]> regionData) {
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buffer);
        while (friendlyBuf.isReadable()) {
            UUID id = friendlyBuf.readUUID();
            byte[] data = friendlyBuf.readByteArray();
            regionData.entries.put(id, data);
            this.indexConstraintData(id, data);
        }
    }

    @Override
    protected void writeRegionData(ByteBuf buffer, Map<UUID, byte[]> entries) {
        FriendlyByteBuf friendlyBuf = new FriendlyByteBuf(buffer);
        for (Map.Entry<UUID, byte[]> entry : entries.entrySet()) {
            friendlyBuf.writeUUID(entry.getKey());
            friendlyBuf.writeByteArray(entry.getValue());
        }
    }

    public void storeConstraintBatch(Map<VxAbstractRegionStorage.RegionPos, Map<UUID, byte[]>> snapshotsByRegion) {
        snapshotsByRegion.forEach(this::storeConstraintBatch);
    }

    public void storeConstraintBatch(VxAbstractRegionStorage.RegionPos regionPos, Map<UUID, byte[]> snapshotBatch) {
        if (snapshotBatch == null || snapshotBatch.isEmpty()) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            for (Map.Entry entry : snapshotBatch.entrySet()) {
                UUID constraintId = (UUID)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                region.entries.put(constraintId, data);
                this.regionIndex.put(constraintId, regionPos);
                this.indexConstraintData(constraintId, data);
            }
            region.dirty.set(true);
            this.saveRegion(regionPos);
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to store constraint batch in region {}", (Object)regionPos, ex);
            return null;
        });
    }

    public void loadConstraintsInChunk(ChunkPos chunkPos) {
        VxAbstractRegionStorage.RegionPos regionPos = new VxAbstractRegionStorage.RegionPos(chunkPos.x >> 5, chunkPos.z >> 5);
        ((CompletableFuture)this.getRegion(regionPos).thenRunAsync(() -> {
            List idsToLoad = (List)this.chunkToUuidIndex.get(chunkPos.toLong());
            if (idsToLoad == null || idsToLoad.isEmpty()) {
                return;
            }
            for (UUID id : List.copyOf(idsToLoad)) {
                if (this.constraintManager.hasActiveConstraint(id) || this.constraintManager.getDataSystem().isPending(id)) continue;
                this.loadConstraint(id);
            }
        }, this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to load constraints in chunk {}", (Object)chunkPos, ex);
            return null;
        });
    }

    public void loadConstraint(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.getRegion(regionPos).thenApplyAsync(region -> {
            byte[] data = (byte[])region.entries.get(id);
            return data != null ? this.deserializeConstraint(id, data) : null;
        }, (Executor)this.ioExecutor)).thenAcceptAsync(constraint -> {
            if (constraint != null) {
                this.constraintManager.addConstraintFromStorage((VxConstraint)constraint);
            }
        }, (Executor)this.level.getServer())).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Exception loading physics constraint {}", (Object)id, ex);
            return null;
        });
    }

    public void removeData(UUID id) {
        VxAbstractRegionStorage.RegionPos regionPos = this.regionIndex.get(id);
        if (regionPos == null) {
            return;
        }
        ((CompletableFuture)this.getRegion(regionPos).thenAcceptAsync(region -> {
            byte[] data = (byte[])region.entries.remove(id);
            if (data != null) {
                region.dirty.set(true);
                this.deIndexConstraint(id, data);
                this.regionIndex.remove(id);
            }
        }, (Executor)this.ioExecutor)).exceptionally(ex -> {
            VxMainClass.LOGGER.error("Failed to remove data for constraint {}", (Object)id, ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VxConstraint deserializeConstraint(UUID id, byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            buf.readLong();
            VxConstraint vxConstraint = VxConstraintCodec.deserialize(id, buf);
            return vxConstraint;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] serializeConstraintData(VxConstraint constraint, ChunkPos pos) {
        ByteBuf buffer = Unpooled.buffer();
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        try {
            buf.writeLong(pos.toLong());
            VxConstraintCodec.serialize(constraint, buf);
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (Exception e) {
            VxMainClass.LOGGER.error("Error during constraint serialization for {}", (Object)constraint.getConstraintId(), (Object)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (buffer.refCnt() > 0) {
                buffer.release();
            }
        }
    }

    private void indexConstraintData(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        this.chunkToUuidIndex.computeIfAbsent(chunkKey, k -> new CopyOnWriteArrayList()).add(id);
    }

    private void deIndexConstraint(UUID id, byte[] data) {
        long chunkKey = this.getChunkKeyFromData(data);
        List idList = (List)this.chunkToUuidIndex.get(chunkKey);
        if (idList != null) {
            idList.remove(id);
            if (idList.isEmpty()) {
                this.chunkToUuidIndex.remove(chunkKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getChunkKeyFromData(byte[] data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        try {
            long l = buf.readLong();
            return l;
        }
        finally {
            if (buf.refCnt() > 0) {
                buf.release();
            }
        }
    }
}

