/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.physics.mounting.manager.VxClientMountingManager;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxMountingEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PHYSICS_ID = SynchedEntityData.defineId(VxMountingEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> SEAT_ID = SynchedEntityData.defineId(VxMountingEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public VxMountingEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
        this.blocksBuilding = false;
        this.setNoGravity(true);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getPassengers().isEmpty()) {
                this.discard();
                return;
            }
            this.restoreMountingLinkIfNeeded();
        }
    }

    private void restoreMountingLinkIfNeeded() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof ServerPlayer) {
            VxMountingManager manager;
            VxPhysicsWorld physicsWorld;
            ServerPlayer player = (ServerPlayer)entity;
            Optional<UUID> physicsIdOpt = this.getPhysicsId();
            Optional<UUID> seatIdOpt = this.getSeatId();
            if (physicsIdOpt.isPresent() && seatIdOpt.isPresent() && (physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.level().dimension())) != null && !(manager = physicsWorld.getMountingManager()).isMounting(player)) {
                manager.restoreMounting(player, physicsIdOpt.get(), seatIdOpt.get());
            }
        }
    }

    public boolean isPushable() {
        return false;
    }

    public void push(Entity entity) {
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void move(MoverType type, Vec3 pos) {
    }

    public boolean isPickable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return false;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PHYSICS_ID, Optional.empty());
        builder.define(SEAT_ID, Optional.empty());
    }

    public Optional<UUID> getPhysicsId() {
        return (Optional)this.entityData.get(PHYSICS_ID);
    }

    public Optional<UUID> getSeatId() {
        return (Optional)this.entityData.get(SEAT_ID);
    }

    public Vector3f getMountPositionOffset() {
        if (this.level().isClientSide()) {
            return this.getPhysicsId().flatMap(objId -> this.getSeatId().flatMap(seatId -> VxClientMountingManager.INSTANCE.getSeat((UUID)objId, (UUID)seatId))).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
        }
        Entity entity = this.getFirstPassenger();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.level().dimension());
            if (physicsWorld != null) {
                VxMountingManager mountingManager = physicsWorld.getMountingManager();
                return mountingManager.getSeatForPlayer(player).map(seat -> new Vector3f((Vector3fc)seat.getRiderOffset())).orElse(new Vector3f());
            }
        }
        return new Vector3f();
    }

    public void setMountInfo(UUID physicsId, UUID seatId) {
        this.entityData.set(PHYSICS_ID, Optional.of(physicsId));
        this.entityData.set(SEAT_ID, Optional.of(seatId));
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (!this.level().isClientSide() && passenger instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)passenger;
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)this.level().dimension());
            if (physicsWorld != null) {
                physicsWorld.getMountingManager().stopMounting(player);
            }
        }
    }

    public boolean isInvisible() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.hasUUID("PhysicsId")) {
            this.entityData.set(PHYSICS_ID, Optional.of(compound.getUUID("PhysicsId")));
        }
        if (compound.hasUUID("SeatId")) {
            this.entityData.set(SEAT_ID, Optional.of(compound.getUUID("SeatId")));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        this.getPhysicsId().ifPresent(uuid -> compound.putUUID("PhysicsId", uuid));
        this.getSeatId().ifPresent(uuid -> compound.putUUID("SeatId", uuid));
    }
}

