/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.input;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.mounting.input.VxMountInput;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class C2SMountInputPacket {
    private final VxMountInput input;

    public C2SMountInputPacket(VxMountInput input) {
        this.input = input;
    }

    public static void encode(C2SMountInputPacket msg, FriendlyByteBuf buf) {
        msg.input.encode(buf);
    }

    public static C2SMountInputPacket decode(FriendlyByteBuf buf) {
        VxMountInput input = new VxMountInput(buf);
        return new C2SMountInputPacket(input);
    }

    public static void handle(C2SMountInputPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.serverLevel().dimension());
            if (physicsWorld != null) {
                VxMountingManager mountingManager = physicsWorld.getMountingManager();
                mountingManager.handlePlayerInput(player, msg.input);
            }
        });
    }
}

