/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.request;

import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.xmx.velthoric.physics.mounting.manager.VxMountingManager;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class C2SRequestMountPacket {
    private final UUID physicsId;
    private final UUID seatId;

    public C2SRequestMountPacket(UUID physicsId, UUID seatId) {
        this.physicsId = physicsId;
        this.seatId = seatId;
    }

    public static void encode(C2SRequestMountPacket msg, FriendlyByteBuf buf) {
        buf.writeUUID(msg.physicsId);
        buf.writeUUID(msg.seatId);
    }

    public static C2SRequestMountPacket decode(FriendlyByteBuf buf) {
        UUID physicsId = buf.readUUID();
        UUID seatId = buf.readUUID();
        return new C2SRequestMountPacket(physicsId, seatId);
    }

    public static void handle(C2SRequestMountPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player == null) {
                return;
            }
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)player.serverLevel().dimension());
            if (physicsWorld != null) {
                VxMountingManager mountingManager = physicsWorld.getMountingManager();
                mountingManager.requestMounting(player, msg.physicsId, msg.seatId);
            }
        });
    }
}

