/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.seat;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxSeat {
    private final UUID seatId;
    private final String seatName;
    private final AABB localAABB;
    private final Vector3f riderOffset;
    private final boolean isDriverSeat;

    public VxSeat(UUID physicsId, String seatName, AABB localAABB, Vector3f riderOffset, boolean isDriverSeat) {
        this.seatId = UUID.nameUUIDFromBytes((physicsId.toString() + seatName).getBytes(StandardCharsets.UTF_8));
        this.seatName = seatName;
        this.localAABB = localAABB;
        this.riderOffset = riderOffset;
        this.isDriverSeat = isDriverSeat;
    }

    public AABB getGlobalAABB(VxTransform objectTransform) {
        Vector3f[] corners = new Vector3f[]{new Vector3f((float)this.localAABB.minX, (float)this.localAABB.minY, (float)this.localAABB.minZ), new Vector3f((float)this.localAABB.maxX, (float)this.localAABB.minY, (float)this.localAABB.minZ), new Vector3f((float)this.localAABB.maxX, (float)this.localAABB.maxY, (float)this.localAABB.minZ), new Vector3f((float)this.localAABB.minX, (float)this.localAABB.maxY, (float)this.localAABB.minZ), new Vector3f((float)this.localAABB.minX, (float)this.localAABB.minY, (float)this.localAABB.maxZ), new Vector3f((float)this.localAABB.maxX, (float)this.localAABB.minY, (float)this.localAABB.maxZ), new Vector3f((float)this.localAABB.maxX, (float)this.localAABB.maxY, (float)this.localAABB.maxZ), new Vector3f((float)this.localAABB.minX, (float)this.localAABB.maxY, (float)this.localAABB.maxZ)};
        Quaternionf rotation = new Quaternionf();
        objectTransform.getRotation(rotation);
        Vector3f translation = new Vector3f();
        objectTransform.getTranslation(translation);
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (Vector3f corner : corners) {
            rotation.transform(corner);
            corner.add((Vector3fc)translation);
            minX = Math.min(minX, corner.x);
            minY = Math.min(minY, corner.y);
            minZ = Math.min(minZ, corner.z);
            maxX = Math.max(maxX, corner.x);
            maxY = Math.max(maxY, corner.y);
            maxZ = Math.max(maxZ, corner.z);
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public VxOBB getGlobalOBB(VxTransform objectTransform) {
        Vec3 localCenter = this.localAABB.getCenter();
        RVec3 localCenterRVec = new RVec3(localCenter.x, localCenter.y, localCenter.z);
        localCenterRVec.rotateInPlace(objectTransform.getRotation());
        RVec3 worldSeatCenter = Op.plus((RVec3Arg)objectTransform.getTranslation(), (RVec3Arg)localCenterRVec);
        VxTransform seatTransform = new VxTransform(worldSeatCenter, objectTransform.getRotation());
        double xSize = this.localAABB.getXsize();
        double ySize = this.localAABB.getYsize();
        double zSize = this.localAABB.getZsize();
        AABB centeredAABB = new AABB(-xSize / 2.0, -ySize / 2.0, -zSize / 2.0, xSize / 2.0, ySize / 2.0, zSize / 2.0);
        return new VxOBB(seatTransform, centeredAABB);
    }

    public UUID getId() {
        return this.seatId;
    }

    public String getName() {
        return this.seatName;
    }

    public AABB getLocalAABB() {
        return this.localAABB;
    }

    public Vector3f getRiderOffset() {
        return this.riderOffset;
    }

    public boolean isDriverSeat() {
        return this.isDriverSeat;
    }

    public static class Builder {
        private final List<VxSeat> seats = new ArrayList<VxSeat>();

        public Builder addSeat(VxSeat seat) {
            this.seats.add(seat);
            return this;
        }

        public List<VxSeat> build() {
            return new ArrayList<VxSeat>(this.seats);
        }
    }
}

