/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.ragdoll;

import com.github.stephengold.joltjni.Vec3;

public enum VxBodyPart {
    HEAD(new Vec3(0.5f, 0.5f, 0.5f), new Vec3(0.0f, 0.375f, 0.0f)),
    TORSO(new Vec3(0.5f, 0.75f, 0.25f), new Vec3(0.0f, 0.0f, 0.0f)),
    LEFT_ARM(new Vec3(0.25f, 0.75f, 0.25f), new Vec3(0.25f, 0.375f, 0.0f)),
    RIGHT_ARM(new Vec3(0.25f, 0.75f, 0.25f), new Vec3(-0.25f, 0.375f, 0.0f)),
    LEFT_LEG(new Vec3(0.25f, 0.75f, 0.25f), new Vec3(0.125f, -0.375f, 0.0f)),
    RIGHT_LEG(new Vec3(0.25f, 0.75f, 0.25f), new Vec3(-0.125f, -0.375f, 0.0f));

    private final Vec3 size;
    private final Vec3 attachmentPointOnTorso;

    private VxBodyPart(Vec3 size, Vec3 attachmentPointOnTorso) {
        this.size = size;
        this.attachmentPointOnTorso = attachmentPointOnTorso;
    }

    public Vec3 getSize() {
        return this.size;
    }

    public Vec3 getAttachmentPointOnTorso() {
        return this.attachmentPointOnTorso;
    }

    public Vec3 getLocalPivot() {
        if (this == TORSO) {
            return new Vec3(0.0f, 0.0f, 0.0f);
        }
        if (this == HEAD) {
            return new Vec3(0.0f, -this.size.getY() / 2.0f, 0.0f);
        }
        if (this == LEFT_ARM) {
            return new Vec3(-this.size.getX() / 2.0f, this.size.getY() / 2.0f, 0.0f);
        }
        if (this == RIGHT_ARM) {
            return new Vec3(this.size.getX() / 2.0f, this.size.getY() / 2.0f, 0.0f);
        }
        return new Vec3(0.0f, this.size.getY() / 2.0f, 0.0f);
    }
}

