/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.ragdoll.body;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import net.xmx.velthoric.physics.ragdoll.VxBodyPart;
import net.xmx.velthoric.physics.ragdoll.body.VxBodyPartRigidBody;
import org.joml.Quaternionf;

public class VxRagdollBodyPartRenderer
extends VxRigidBodyRenderer<VxBodyPartRigidBody> {
    private HumanoidModel<LivingEntity> model;
    private final Map<VxBodyPart, ModelPart> partMap = new EnumMap<VxBodyPart, ModelPart>(VxBodyPart.class);
    private boolean isInitialized = false;

    private void initialize() {
        ModelPart root = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER);
        this.model = new HumanoidModel(root);
        this.partMap.put(VxBodyPart.HEAD, this.model.head);
        this.partMap.put(VxBodyPart.TORSO, this.model.body);
        this.partMap.put(VxBodyPart.LEFT_ARM, this.model.leftArm);
        this.partMap.put(VxBodyPart.RIGHT_ARM, this.model.rightArm);
        this.partMap.put(VxBodyPart.LEFT_LEG, this.model.leftLeg);
        this.partMap.put(VxBodyPart.RIGHT_LEG, this.model.rightLeg);
        this.isInitialized = true;
    }

    @Override
    public void render(VxBodyPartRigidBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        VxBodyPart partType;
        ModelPart modelPart;
        if (!this.isInitialized) {
            this.initialize();
        }
        if ((modelPart = this.partMap.get((Object)(partType = body.getSyncData(VxBodyPartRigidBody.DATA_BODY_PART)))) == null) {
            return;
        }
        poseStack.pushPose();
        VxTransform transform = renderState.transform;
        poseStack.translate(transform.getTranslation().x(), transform.getTranslation().y(), transform.getTranslation().z());
        poseStack.mulPose(new Quaternionf(transform.getRotation().getX(), transform.getRotation().getY(), transform.getRotation().getZ(), transform.getRotation().getW()));
        float scaleX = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getX() * 2.0f / partType.getSize().getX();
        float scaleY = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getY() * 2.0f / partType.getSize().getY();
        float scaleZ = body.getSyncData(VxBodyPartRigidBody.DATA_HALF_EXTENTS).getZ() * 2.0f / partType.getSize().getZ();
        poseStack.scale(scaleX, scaleY, scaleZ);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        poseStack.translate(-modelPart.x / 16.0f, -modelPart.y / 16.0f, -modelPart.z / 16.0f);
        switch (partType) {
            case HEAD: {
                poseStack.translate(0.0, 0.25, 0.0);
                break;
            }
            case TORSO: 
            case LEFT_LEG: 
            case RIGHT_LEG: {
                poseStack.translate(0.0, -0.375, 0.0);
                break;
            }
            case LEFT_ARM: {
                poseStack.translate(-0.0625, -0.25, 0.0);
                break;
            }
            case RIGHT_ARM: {
                poseStack.translate(0.0625, -0.25, 0.0);
            }
        }
        ResourceLocation skinTexture = this.getSkinTexture(body);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)skinTexture));
        modelPart.render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    private ResourceLocation getSkinTexture(VxBodyPartRigidBody body) {
        String skinIdStr = body.getSyncData(VxBodyPartRigidBody.DATA_SKIN_ID);
        if (skinIdStr == null || skinIdStr.isEmpty()) {
            return DefaultPlayerSkin.getDefaultTexture();
        }
        try {
            PlayerInfo playerInfo;
            UUID playerUuid = UUID.fromString(skinIdStr);
            if (Minecraft.getInstance().getConnection() != null && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(playerUuid)) != null) {
                return playerInfo.getSkin().texture();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return DefaultPlayerSkin.getDefaultTexture();
    }
}

