/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.Vec3;
import java.util.Optional;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class VxHitResult
extends HitResult {
    private final HitResult minecraftHit;
    private final PhysicsHit physicsHit;

    public VxHitResult(HitResult minecraftHit) {
        super(minecraftHit.getLocation());
        this.minecraftHit = minecraftHit;
        this.physicsHit = null;
    }

    public VxHitResult(net.minecraft.world.phys.Vec3 location, int bodyId, Vec3 hitNormal, float hitFraction) {
        super(location);
        this.minecraftHit = null;
        this.physicsHit = new PhysicsHit(bodyId, hitNormal, hitFraction);
    }

    public HitResult.Type getType() {
        if (this.isPhysicsHit()) {
            return HitResult.Type.BLOCK;
        }
        return this.minecraftHit != null ? this.minecraftHit.getType() : HitResult.Type.MISS;
    }

    public boolean isPhysicsHit() {
        return this.physicsHit != null;
    }

    public Optional<PhysicsHit> getPhysicsHit() {
        return Optional.ofNullable(this.physicsHit);
    }

    public Optional<BlockHitResult> getBlockHit() {
        HitResult hitResult = this.minecraftHit;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            return Optional.of(blockHit);
        }
        return Optional.empty();
    }

    public Optional<EntityHitResult> getEntityHit() {
        HitResult hitResult = this.minecraftHit;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            return Optional.of(entityHit);
        }
        return Optional.empty();
    }

    public record PhysicsHit(int bodyId, Vec3 hitNormal, float hitFraction) {
    }
}

