/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.raycasting;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.xmx.velthoric.physics.raycasting.VxClipContext;
import net.xmx.velthoric.physics.raycasting.VxHitResult;
import net.xmx.velthoric.physics.raycasting.VxObjectLayerFilters;
import net.xmx.velthoric.physics.raycasting.VxPhysicsRaycaster;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public final class VxRaycaster {
    private VxRaycaster() {
    }

    public static Optional<VxHitResult> raycast(Level level, VxClipContext context) {
        net.minecraft.world.phys.Vec3 from = context.getFrom();
        net.minecraft.world.phys.Vec3 to = context.getTo();
        ArrayList hits = new ArrayList();
        VxRaycaster.raycastMinecraft(level, context).ifPresent(hits::add);
        if (context.isIncludePhysics()) {
            VxPhysicsWorld physicsWorld = VxPhysicsWorld.get((ResourceKey<Level>)level.dimension());
            double maxDistance = from.distanceTo(to);
            net.minecraft.world.phys.Vec3 direction = to.subtract(from).normalize();
            RVec3 rayOrigin = new RVec3((float)from.x, (float)from.y, (float)from.z);
            Vec3 rayDirection = new Vec3((float)direction.x, (float)direction.y, (float)direction.z);
            VxRaycaster.raycastPhysics(physicsWorld, rayOrigin, rayDirection, (float)maxDistance).ifPresent(hits::add);
        }
        return hits.stream().min(Comparator.comparingDouble(hit -> hit.getLocation().distanceToSqr(from)));
    }

    public static Optional<VxHitResult> raycastMinecraft(Level level, VxClipContext context) {
        double entityHitSq;
        Predicate<Entity> entityPredicate;
        AABB searchBox;
        EntityHitResult entityHitResult;
        net.minecraft.world.phys.Vec3 from = context.getFrom();
        net.minecraft.world.phys.Vec3 to = context.getTo();
        BlockHitResult blockHitResult = level.clip((ClipContext)context);
        double closestHitSq = blockHitResult.getType() == HitResult.Type.MISS ? Double.MAX_VALUE : blockHitResult.getLocation().distanceToSqr(from);
        BlockHitResult finalHit = blockHitResult;
        Entity entity = context.getEntity();
        if (entity != null && (entityHitResult = ProjectileUtil.getEntityHitResult((Level)level, (Entity)entity, (net.minecraft.world.phys.Vec3)from, (net.minecraft.world.phys.Vec3)to, (AABB)(searchBox = new AABB(from, to)), entityPredicate = e -> !e.isSpectator() && e.isPickable())) != null && (entityHitSq = entityHitResult.getLocation().distanceToSqr(from)) < closestHitSq) {
            finalHit = entityHitResult;
        }
        return finalHit.getType() != HitResult.Type.MISS ? Optional.of(new VxHitResult((HitResult)finalHit)) : Optional.empty();
    }

    public static Optional<VxHitResult> raycastPhysics(VxPhysicsWorld physicsWorld, RVec3 rayOrigin, Vec3 rayDirection, float maxDistance) {
        Optional<VxPhysicsRaycaster.Result> physicsResult = VxPhysicsRaycaster.raycast(physicsWorld, rayOrigin, rayDirection, maxDistance, VxObjectLayerFilters.IGNORE_TERRAIN);
        return physicsResult.map(hit -> {
            RVec3 hitPointR = hit.hitPoint();
            net.minecraft.world.phys.Vec3 hitPoint = new net.minecraft.world.phys.Vec3(hitPointR.xx(), hitPointR.yy(), hitPointR.zz());
            return new VxHitResult(hitPoint, hit.bodyId(), hit.hitNormal(), hit.hitFraction());
        });
    }
}

