/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.sync;

import dev.architectury.networking.NetworkManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.vehicle.VxVehicle;

public class S2CVehicleStatePacket {
    private final int networkId;
    private final float speedKmh;
    private final float[] rotationAngles;
    private final float[] steerAngles;
    private final float[] suspensionLengths;

    public S2CVehicleStatePacket(int networkId, float speedKmh, float[] rotationAngles, float[] steerAngles, float[] suspensionLengths) {
        this.networkId = networkId;
        this.speedKmh = speedKmh;
        this.rotationAngles = rotationAngles;
        this.steerAngles = steerAngles;
        this.suspensionLengths = suspensionLengths;
    }

    public static void encode(S2CVehicleStatePacket msg, FriendlyByteBuf buf) {
        buf.writeVarInt(msg.networkId);
        buf.writeFloat(msg.speedKmh);
        buf.writeVarInt(msg.rotationAngles.length);
        for (int i = 0; i < msg.rotationAngles.length; ++i) {
            buf.writeFloat(msg.rotationAngles[i]);
            buf.writeFloat(msg.steerAngles[i]);
            buf.writeFloat(msg.suspensionLengths[i]);
        }
    }

    public static S2CVehicleStatePacket decode(FriendlyByteBuf buf) {
        int networkId = buf.readVarInt();
        float speedKmh = buf.readFloat();
        int wheelCount = buf.readVarInt();
        float[] rotationAngles = new float[wheelCount];
        float[] steerAngles = new float[wheelCount];
        float[] suspensionLengths = new float[wheelCount];
        for (int i = 0; i < wheelCount; ++i) {
            rotationAngles[i] = buf.readFloat();
            steerAngles[i] = buf.readFloat();
            suspensionLengths[i] = buf.readFloat();
        }
        return new S2CVehicleStatePacket(networkId, speedKmh, rotationAngles, steerAngles, suspensionLengths);
    }

    public static void handle(S2CVehicleStatePacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            Integer index = store.getIndexForNetworkId(msg.networkId);
            if (index == null) {
                return;
            }
            UUID vehicleUuid = store.getUuidForIndex(index);
            if (vehicleUuid == null) {
                return;
            }
            VxBody body = manager.getBody(vehicleUuid);
            if (body instanceof VxVehicle) {
                VxVehicle vehicle = (VxVehicle)body;
                vehicle.updateVehicleState(msg.speedKmh);
                for (int i = 0; i < msg.rotationAngles.length; ++i) {
                    vehicle.updateWheelState(i, msg.rotationAngles[i], msg.steerAngles[i], msg.suspensionLengths[i]);
                }
            }
        });
    }
}

