/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.vehicle.type.motorcycle;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.MotorcycleController;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleController;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.manager.VxJoltBridge;
import net.xmx.velthoric.physics.body.manager.VxRemovalReason;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.mounting.input.VxMountInput;
import net.xmx.velthoric.physics.vehicle.VxSteering;
import net.xmx.velthoric.physics.vehicle.VxVehicle;
import net.xmx.velthoric.physics.vehicle.controller.VxMotorcycleController;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public abstract class VxMotorcycle
extends VxVehicle {
    public static final VxDataAccessor<Vec3> DATA_CHASSIS_HALF_EXTENTS = VxDataAccessor.create(VxMotorcycle.class, VxDataSerializers.VEC3);
    private float previousForward = 1.0f;
    private VxMotorcycleController controller;
    private final VxSteering steering = new VxSteering(1.5f);
    private VxMountInput currentInput = VxMountInput.NEUTRAL;

    protected VxMotorcycle(VxBodyType<? extends VxMotorcycle> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxVehicle>)type, world, id);
        this.constraintSettings = this.createConstraintSettings();
        this.collisionTester = this.createCollisionTester();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected VxMotorcycle(VxBodyType<? extends VxMotorcycle> type, UUID id) {
        super((VxBodyType<? extends VxVehicle>)type, id);
    }

    protected abstract VehicleConstraintSettings createConstraintSettings();

    protected abstract VehicleCollisionTester createCollisionTester();

    @Override
    public void onBodyAdded(VxPhysicsWorld world) {
        super.onBodyAdded(world);
        VehicleController vehicleController = this.constraint.getController();
        if (!(vehicleController instanceof MotorcycleController)) {
            throw new IllegalStateException("VxMotorcycle requires a MotorcycleController.");
        }
        MotorcycleController joltController = (MotorcycleController)vehicleController;
        this.controller = new VxMotorcycleController(joltController);
    }

    @Override
    public void onBodyRemoved(VxPhysicsWorld world, VxRemovalReason reason) {
        super.onBodyRemoved(world, reason);
        this.controller = null;
    }

    @Override
    public void physicsTick(VxPhysicsWorld world) {
        super.physicsTick(world);
        if (this.controller == null || this.physicsWorld == null) {
            return;
        }
        float tickDelta = 0.05f;
        this.steering.update(0.05f);
        float forwardInput = 0.0f;
        float brakeInput = 0.0f;
        if (this.currentInput.isForward()) {
            forwardInput = 1.0f;
        } else if (this.currentInput.isBackward()) {
            forwardInput = -1.0f;
        }
        if (this.previousForward * forwardInput < 0.0f) {
            Body joltBody = VxJoltBridge.INSTANCE.getJoltBody(this.physicsWorld, this.getBodyId());
            if (joltBody == null) {
                return;
            }
            Vec3 localVelocity = Op.star((QuatArg)joltBody.getRotation().conjugated(), (Vec3Arg)joltBody.getLinearVelocity());
            float zVelocity = localVelocity.getZ();
            if (forwardInput > 0.0f && zVelocity < -0.1f || forwardInput < 0.0f && zVelocity > 0.1f) {
                forwardInput = 0.0f;
                brakeInput = 1.0f;
            } else {
                this.previousForward = forwardInput;
            }
        }
        float handBrakeInput = this.currentInput.isUp() ? 1.0f : 0.0f;
        this.physicsWorld.getPhysicsSystem().getBodyInterface().activateBody(this.getBodyId());
        this.controller.setInput(forwardInput, this.steering.getCurrentAngle(), brakeInput, handBrakeInput);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        super.defineSyncData(builder);
        builder.define(DATA_CHASSIS_HALF_EXTENTS, new Vec3(0.2f, 0.3f, 0.4f));
    }

    @Override
    public void onStopMounting(ServerPlayer player) {
        if (this.controller != null) {
            this.controller.setInput(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.currentInput = VxMountInput.NEUTRAL;
        this.steering.reset();
        this.previousForward = 1.0f;
    }

    @Override
    public void handleDriverInput(ServerPlayer player, VxMountInput input) {
        this.currentInput = input;
        float targetRight = 0.0f;
        if (input.isRight()) {
            targetRight = 1.0f;
        } else if (input.isLeft()) {
            targetRight = -1.0f;
        }
        this.steering.setTargetAngle(targetRight);
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        super.writePersistenceData(buf);
        DATA_CHASSIS_HALF_EXTENTS.getSerializer().write(buf, this.getSyncData(DATA_CHASSIS_HALF_EXTENTS));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        super.readPersistenceData(buf);
        this.setSyncData(DATA_CHASSIS_HALF_EXTENTS, DATA_CHASSIS_HALF_EXTENTS.getSerializer().read(buf));
    }

    public Vec3 getChassisHalfExtents() {
        return this.getSyncData(DATA_CHASSIS_HALF_EXTENTS);
    }

    public VxMotorcycleController getController() {
        return this.controller;
    }
}

